<?php
if (!defined('ABSPATH')) {
    exit;
}

$user = get_userdata($ticket->user_id);
$customer_details = nexlifydesk_extract_customer_details($ticket->message);
$customer_name = $user ? $user->display_name : ($customer_details['name'] ?: 'Customer');

$ticket_url = add_query_arg(
    array('ticket_id' => $ticket->ticket_id),
    NexlifyDesk_Admin::get_ticket_page_url()
);
?>
<p>Hello <?php echo esc_html($customer_name); ?>,</p>

<p>The status of your support ticket has been updated.</p>

<p><strong>Ticket Details:</strong></p>
<ul>
    <li><strong>Ticket ID:</strong> #<?php echo esc_html($ticket->ticket_id); ?></li>
    <li><strong>Subject:</strong> <?php echo esc_html($ticket->subject); ?></li>
    <li><strong>Previous Status:</strong> <?php echo esc_html(ucfirst($ticket->status)); ?></li>
    <li><strong>Current Status:</strong> <?php echo esc_html(ucfirst($ticket->status)); ?></li>
    <li><strong>Priority:</strong> <?php echo esc_html(ucfirst($ticket->priority)); ?></li>
    <li><strong>Updated:</strong> <?php echo esc_html(gmdate(get_option('date_format') . ' ' . get_option('time_format'), strtotime($ticket->updated_at))); ?></li>
</ul>

<p>You can view your ticket and track its progress by clicking the link below:</p>

<p><a href="<?php echo esc_url($ticket_url); ?>" style="background-color: #0073aa; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;">View Ticket</a></p>

<p>Thank you for your patience. Our support team is working to resolve your request.</p>

<p>Best regards,<br>
<?php echo esc_html(get_bloginfo('name')); ?> Support Team</p>