<?php
if (!defined('ABSPATH')) {
    exit;
}

$user = get_userdata($ticket->user_id);
$customer_details = nexlifydesk_extract_customer_details($ticket->message);
$customer_name = $user ? $user->display_name : ($customer_details['name'] ?: 'Customer');

$ticket_admin_url = add_query_arg(
    array(
        'page' => 'nexlifydesk_tickets',
        'ticket_id' => $ticket->id,
    ),
    admin_url('admin.php')
);
?>
<p><strong>SLA Breach Alert</strong></p>

<p>This is an urgent notification that a support ticket has breached its SLA (Service Level Agreement) response time.</p>

<p><strong>Ticket Details:</strong></p>
<ul>
    <li><strong>Ticket ID:</strong> #<?php echo esc_html($ticket->ticket_id); ?></li>
    <li><strong>Subject:</strong> <?php echo esc_html($ticket->subject); ?></li>
    <li><strong>Customer:</strong> <?php echo esc_html($customer_name); ?></li>
    <li><strong>Priority:</strong> <?php echo esc_html(ucfirst($ticket->priority)); ?></li>
    <li><strong>Status:</strong> <?php echo esc_html(ucfirst($ticket->status)); ?></li>
    <li><strong>Created:</strong> <?php echo esc_html(gmdate(get_option('date_format') . ' ' . get_option('time_format'), strtotime($ticket->created_at))); ?></li>
    <li><strong>Last Updated:</strong> <?php echo esc_html(gmdate(get_option('date_format') . ' ' . get_option('time_format'), strtotime($ticket->updated_at))); ?></li>
</ul>

<p><strong>Immediate Action Required:</strong></p>
<p>This ticket requires immediate attention to prevent further SLA violations. Please review and respond promptly.</p>

<p><a href="<?php echo esc_url($ticket_admin_url); ?>" style="background-color: #d63638; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;">View Ticket Now</a></p>

<p>This is an automated alert from the <?php echo esc_html(get_bloginfo('name')); ?> support system.</p>