<?php
if (!defined('ABSPATH')) {
    exit;
}

$user = get_userdata($ticket->user_id);
$customer_details = nexlifydesk_extract_customer_details($ticket->message);
$customer_name = $user ? $user->display_name : ($customer_details['name'] ?: 'Customer');
$customer_email = $user ? $user->user_email : ($customer_details['email'] ?: '');
$clean_message = $customer_details['message'] ?: $ticket->message;

$ticket_url = add_query_arg(
    array('ticket_id' => $ticket->ticket_id),
    NexlifyDesk_Admin::get_ticket_page_url()
);
?>
<p>Hello <?php echo esc_html($customer_name); ?>,</p>

<p>Thank you for contacting us. Your support ticket has been created successfully.</p>

<p><strong>Ticket Details:</strong></p>
<ul>
    <li><strong>Ticket ID:</strong> #<?php echo esc_html($ticket->ticket_id); ?></li>
    <li><strong>Subject:</strong> <?php echo esc_html($ticket->subject); ?></li>
    <li><strong>Priority:</strong> <?php echo esc_html(ucfirst($ticket->priority)); ?></li>
    <li><strong>Status:</strong> <?php echo esc_html(ucfirst($ticket->status)); ?></li>
    <li><strong>Created:</strong> <?php echo esc_html(gmdate(get_option('date_format') . ' ' . get_option('time_format'), strtotime($ticket->created_at))); ?></li>
</ul>

<p><strong>Your Message:</strong></p>
<div style="background-color: #f9f9f9; padding: 15px; border-left: 4px solid #ddd;">
    <?php echo wp_kses(wpautop(wp_kses_post($clean_message)), array(
        'p' => array(),
        'br' => array(),
        'strong' => array(),
        'em' => array(),
        'ul' => array(),
        'ol' => array(),
        'li' => array(),
        'a' => array(
            'href' => array(),
            'title' => array(),
            'rel' => array(),
            'target' => array(),
        ),
    )); ?>
</div>

<p>Our support team will review your request and get back to you as soon as possible. You can view and track your ticket status at any time by clicking the link below:</p>

<p><a href="<?php echo esc_url($ticket_url); ?>" style="background-color: #0073aa; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;">View Ticket</a></p>

<p>Please keep this ticket ID (#<?php echo esc_html($ticket->ticket_id); ?>) for your records and reference it in any future correspondence.</p>

<p>Best regards,<br>
<?php echo esc_html(get_bloginfo('name')); ?> Support Team</p>