<?php
if (!defined('ABSPATH')) {
    exit;
}

$user = get_userdata($ticket->user_id);
$customer_details = nexlifydesk_extract_customer_details($ticket->message);
$customer_name = $user ? $user->display_name : ($customer_details['name'] ?: 'Customer');

// Get the reply information
$reply = null;
if ($reply_id) {
    $replies = NexlifyDesk_Tickets::get_replies($ticket->id);
    foreach ($replies as $r) {
        if ($r->id == $reply_id) {
            $reply = $r;
            break;
        }
    }
}

$reply_customer_details = $reply ? nexlifydesk_extract_customer_details($reply->message) : array();
$reply_message = $reply ? ($reply_customer_details['message'] ?: $reply->message) : '';
$reply_user = $reply ? get_userdata($reply->user_id) : null;
$reply_user_name = $reply_user ? $reply_user->display_name : ($reply_customer_details['name'] ?: 'Guest');

$ticket_url = add_query_arg(
    array('ticket_id' => $ticket->ticket_id),
    NexlifyDesk_Admin::get_ticket_page_url()
);
?>
<p>Hello <?php echo esc_html($customer_name); ?>,</p>

<p>A new reply has been added to your support ticket.</p>

<p><strong>Ticket Details:</strong></p>
<ul>
    <li><strong>Ticket ID:</strong> #<?php echo esc_html($ticket->ticket_id); ?></li>
    <li><strong>Subject:</strong> <?php echo esc_html($ticket->subject); ?></li>
    <li><strong>Status:</strong> <?php echo esc_html(ucfirst($ticket->status)); ?></li>
    <li><strong>Reply From:</strong> <?php echo esc_html($reply_user_name); ?></li>
</ul>

<?php if ($reply_message): ?>
<p><strong>New Reply:</strong></p>
<div style="background-color: #f9f9f9; padding: 15px; border-left: 4px solid #0073aa;">
    <?php echo wp_kses_post(wpautop($reply_message)); ?>
</div>
<?php endif; ?>

<p>You can view the full conversation and respond to this ticket by clicking the link below:</p>

<p><a href="<?php echo esc_url($ticket_url); ?>" style="background-color: #0073aa; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;">View Ticket</a></p>

<p>Best regards,<br>
<?php echo esc_html(get_bloginfo('name')); ?> Support Team</p>