<?php
if (!defined('ABSPATH')) {
    exit;
}

if (!current_user_can('nexlifydesk_manage_tickets')) {
    wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'nexlifydesk'));
}

// Ticket statistics

$stats = array();
if (class_exists('NexlifyDesk_Reports')) {
    $stats = NexlifyDesk_Reports::get_dashboard_stats();
}
?>
<div class="wrap">
    <h1 style="display: none;"></h1>
</div>

<!-- Main ticket list UI -->
<div class="wrap nexlifydesk-admin-ticket-list-ui">

    <div class="header">
        <h1><?php esc_html_e('Support Tickets', 'nexlifydesk'); ?></h1>
        <p><?php esc_html_e('Manage and track customer support requests', 'nexlifydesk'); ?></p>
        <button id="manual-refresh-btn" class="button" style="margin-left: 10px;"><?php esc_html_e('Refresh Now', 'nexlifydesk'); ?></button>
    </div>

    <div class="stats">
        <div class="stat-card">
            <div class="stat-number">
                <?php
                $open = isset($stats['status_breakdown']['open']) ? (int)$stats['status_breakdown']['open'] : 0;
                $pending = isset($stats['status_breakdown']['pending']) ? (int)$stats['status_breakdown']['pending'] : 0;
                $in_progress = isset($stats['status_breakdown']['in_progress']) ? (int)$stats['status_breakdown']['in_progress'] : 0;
                echo esc_html($open + $pending + $in_progress);
                ?>
            </div>
            <div class="stat-label"><?php esc_html_e('Open Tickets', 'nexlifydesk'); ?></div>
        </div>
        <div class="stat-card">
            <div class="stat-number"><?php echo isset($stats['status_breakdown']['in_progress']) ? esc_html($stats['status_breakdown']['in_progress']) : '0'; ?></div>
            <div class="stat-label"><?php esc_html_e('In Progress', 'nexlifydesk'); ?></div>
        </div>
        <div class="stat-card">
            <div class="stat-number"><?php echo isset($stats['closed_tickets']) ? esc_html($stats['closed_tickets']) : '0'; ?></div>
            <div class="stat-label"><?php esc_html_e('Resolved This Month', 'nexlifydesk'); ?></div>
        </div>
        <div class="stat-card">
            <div class="stat-number"><?php echo isset($stats['avg_response_time']) ? esc_html($stats['avg_response_time']) : '0h'; ?></div>
            <div class="stat-label"><?php esc_html_e('Avg Response Time', 'nexlifydesk'); ?></div>
        </div>
    </div>

    <div class="controls">
        <div class="bulk-actions">
            <input type="checkbox" id="select-all-tickets" class="select-all-checkbox">
            <select id="bulk-action-select" class="bulk-action-dropdown" disabled>
                <option value=""><?php esc_html_e('Bulk Actions', 'nexlifydesk'); ?></option>
                <option value="assign"><?php esc_html_e('Assign to Agent', 'nexlifydesk'); ?></option>
                <option value="status"><?php esc_html_e('Change Status', 'nexlifydesk'); ?></option>
                <option value="priority"><?php esc_html_e('Change Priority', 'nexlifydesk'); ?></option>
                <?php if (current_user_can('manage_options')): ?>
                <option value="delete" class="delete-option" style="color: #d63638;"><?php esc_html_e('Delete Tickets (Admin Only)', 'nexlifydesk'); ?></option>
                <?php endif; ?>
            </select>
            <button id="apply-bulk-action" class="button button-primary" disabled><?php esc_html_e('Apply', 'nexlifydesk'); ?></button>
        </div>
        
        <div class="search-bar">
            <span class="search-icon dashicons dashicons-search"></span>
            <input type="text" id="ticket-search" placeholder="<?php esc_attr_e('Search tickets...', 'nexlifydesk'); ?>">
        </div>
        
        <select id="ticket-status-filter" class="filter-dropdown">
            <option value="all"><?php esc_html_e('All Statuses', 'nexlifydesk'); ?></option>
            <option value="open"><?php esc_html_e('Open', 'nexlifydesk'); ?></option>
            <option value="in_progress"><?php esc_html_e('In Progress', 'nexlifydesk'); ?></option>
            <option value="resolved"><?php esc_html_e('Resolved', 'nexlifydesk'); ?></option>
            <option value="closed"><?php esc_html_e('Closed', 'nexlifydesk'); ?></option>
        </select>
        
        <select id="ticket-priority-filter" class="filter-dropdown">
            <option value="all"><?php esc_html_e('All Priorities', 'nexlifydesk'); ?></option>
            <option value="high"><?php esc_html_e('High', 'nexlifydesk'); ?></option>
            <option value="medium"><?php esc_html_e('Medium', 'nexlifydesk'); ?></option>
            <option value="low"><?php esc_html_e('Low', 'nexlifydesk'); ?></option>
        </select>
    </div>

    <div id="nexlifydesk-ticket-list" class="ticket-list">
        <div class="ticket-list-header">
            <div class="header-checkbox">
                <input type="checkbox" id="header-select-all" class="select-all-checkbox">
            </div>
            <div class="header-subject"><?php esc_html_e('Subject', 'nexlifydesk'); ?></div>
            <div class="header-customer"><?php esc_html_e('Customer', 'nexlifydesk'); ?></div>
            <div class="header-status"><?php esc_html_e('Status', 'nexlifydesk'); ?></div>
            <div class="header-priority"><?php esc_html_e('Priority', 'nexlifydesk'); ?></div>
            <div class="header-assignee"><?php esc_html_e('Assignee', 'nexlifydesk'); ?></div>
            <div class="header-created"><?php esc_html_e('Created', 'nexlifydesk'); ?></div>
            <div class="header-updated"><?php esc_html_e('Last Updated', 'nexlifydesk'); ?></div>
        </div>
        
        <div class="ticket-list-body">
            <?php
            if (class_exists('NexlifyDesk_Tickets')) {
                $initial_tickets = NexlifyDesk_Tickets::get_tickets_for_grid();
                if (!empty($initial_tickets)) {
                    foreach ($initial_tickets as $ticket) {
                        $user = get_userdata($ticket->user_id);
                        $assigned_agent = $ticket->assigned_to ? get_userdata($ticket->assigned_to) : null;
                        
                        if (!$user) {
                            $customer_details = function_exists('nexlifydesk_extract_customer_details') ? 
                                nexlifydesk_extract_customer_details($ticket->message) : 
                                ['name' => '', 'email' => '', 'message' => $ticket->message];
                            $customer_name = $customer_details['name'] ?: 'Guest';
                            $customer_email = $customer_details['email'] ?: 'N/A';
                        } else {
                            $customer_name = $user->display_name;
                            $customer_email = $user->user_email;
                        }
                        ?>
                        <?php 
                        $is_unread = isset($ticket->is_unread) ? $ticket->is_unread : false;
                        $last_reply_time = isset($ticket->last_reply_time) ? $ticket->last_reply_time : $ticket->created_at;
                        $last_updated_time = isset($ticket->last_updated_time) ? $ticket->last_updated_time : $ticket->updated_at;
                        ?>
                        <div class="ticket-row <?php echo $is_unread ? 'unread' : ''; ?>" 
                            data-ticket-id="<?php echo esc_attr($ticket->id); ?>"
                            data-last-reply="<?php echo esc_attr(strtotime($last_reply_time)); ?>"
                            data-is-unread="<?php echo $is_unread ? '1' : '0'; ?>"
                            data-status="<?php echo esc_attr($ticket->status); ?>"
                            data-priority="<?php echo esc_attr($ticket->priority); ?>">
                            <div class="row-checkbox">
                                <input type="checkbox" class="ticket-checkbox" value="<?php echo esc_attr($ticket->id); ?>">
                            </div>
                            <div class="row-subject">
                                <a href="<?php echo esc_url(admin_url('admin.php?page=nexlifydesk_tickets&ticket_id=' . $ticket->id)); ?>" class="ticket-link">
                                    <?php if ($is_unread): ?><span class="unread-dot"></span><?php endif; ?>
                                    <span class="ticket-id">#<?php echo esc_html($ticket->ticket_id); ?></span>
                                    <span class="ticket-title <?php echo $is_unread ? 'unread-title' : ''; ?>"><?php echo esc_html($ticket->subject); ?></span>
                                </a>
                                <div class="ticket-preview"><?php echo esc_html(wp_trim_words($ticket->message, 15)); ?></div>
                            </div>
                            <div class="row-customer">
                                <span class="customer-name"><?php echo esc_html($customer_name); ?></span>
                                <span class="customer-email"><?php echo esc_html($customer_email); ?></span>
                            </div>
                            <div class="row-status">
                                <span class="status-badge status-<?php echo esc_attr($ticket->status); ?>">
                                    <?php echo esc_html(ucfirst(str_replace('_', ' ', $ticket->status))); ?>
                                </span>
                            </div>
                            <div class="row-priority">
                                <span class="priority-badge priority-<?php echo esc_attr($ticket->priority); ?>">
                                    <?php echo esc_html(ucfirst($ticket->priority)); ?>
                                </span>
                            </div>
                            <div class="row-assignee">
                                <?php if ($assigned_agent): ?>
                                    <div class="assignee-info">
                                        <div class="avatar"><?php echo esc_html(substr($assigned_agent->display_name, 0, 1)); ?></div>
                                        <span><?php echo esc_html($assigned_agent->display_name); ?></span>
                                    </div>
                                <?php else: ?>
                                    <span class="unassigned"><?php esc_html_e('Unassigned', 'nexlifydesk'); ?></span>
                                <?php endif; ?>
                            </div>
                            <div class="row-created">
                                <span class="date-time"><?php echo esc_html(date_i18n('M j, Y', strtotime($ticket->created_at))); ?></span>
                                <span class="time-ago"><?php echo esc_html(human_time_diff(strtotime($ticket->created_at), current_time('timestamp')) . ' ago'); ?></span>
                            </div>
                            <div class="row-updated">
                                <span class="date-time"><?php echo esc_html(date_i18n('M j, Y', strtotime($last_reply_time))); ?></span>
                                <span class="time-ago"><?php echo esc_html(human_time_diff(strtotime($last_reply_time), current_time('timestamp')) . ' ago'); ?></span>
                            </div>
                        </div>
                        <?php
                    }
                } else {
                    echo '<div class="no-tickets">' . esc_html__('No tickets found.', 'nexlifydesk') . '</div>';
                }
            } else {
                echo '<div class="no-tickets">' . esc_html__('Tickets system not available.', 'nexlifydesk') . '</div>';
            }
            ?>
        </div>
    </div>

    <input type="hidden" id="nexlifydesk-nonce" value="<?php echo esc_attr(wp_create_nonce('nexlifydesk-ajax-nonce')); ?>">

    <div id="bulk-assign-modal" class="bulk-modal" style="display: none;">
        <div class="modal-content">
            <h3><?php esc_html_e('Assign Tickets to Agent', 'nexlifydesk'); ?></h3>
            <select id="bulk-assign-agent">
                <option value=""><?php esc_html_e('Select Agent', 'nexlifydesk'); ?></option>
                <?php
                $agents = get_users(array('capability' => 'nexlifydesk_manage_tickets'));
                foreach ($agents as $agent) {
                    echo '<option value="' . esc_attr($agent->ID) . '">' . esc_html($agent->display_name) . '</option>';
                }
                ?>
            </select>
            <div class="modal-actions">
                <button id="cancel-bulk-assign" class="button"><?php esc_html_e('Cancel', 'nexlifydesk'); ?></button>
                <button id="confirm-bulk-assign" class="button button-primary"><?php esc_html_e('Assign', 'nexlifydesk'); ?></button>
            </div>
        </div>
    </div>

    <div id="bulk-status-modal" class="bulk-modal" style="display: none;">
        <div class="modal-content">
            <h3><?php esc_html_e('Change Ticket Status', 'nexlifydesk'); ?></h3>
            <select id="bulk-status-select">
                <option value="open"><?php esc_html_e('Open', 'nexlifydesk'); ?></option>
                <option value="in_progress"><?php esc_html_e('In Progress', 'nexlifydesk'); ?></option>
                <option value="resolved"><?php esc_html_e('Resolved', 'nexlifydesk'); ?></option>
                <option value="closed"><?php esc_html_e('Closed', 'nexlifydesk'); ?></option>
            </select>
            <div class="modal-actions">
                <button id="cancel-bulk-status" class="button"><?php esc_html_e('Cancel', 'nexlifydesk'); ?></button>
                <button id="confirm-bulk-status" class="button button-primary"><?php esc_html_e('Update', 'nexlifydesk'); ?></button>
            </div>
        </div>
    </div>

    <div id="bulk-priority-modal" class="bulk-modal" style="display: none;">
        <div class="modal-content">
            <h3><?php esc_html_e('Change Ticket Priority', 'nexlifydesk'); ?></h3>
            <select id="bulk-priority-select">
                <option value="low"><?php esc_html_e('Low', 'nexlifydesk'); ?></option>
                <option value="medium"><?php esc_html_e('Medium', 'nexlifydesk'); ?></option>
                <option value="high"><?php esc_html_e('High', 'nexlifydesk'); ?></option>
            </select>
            <div class="modal-actions">
                <button id="cancel-bulk-priority" class="button"><?php esc_html_e('Cancel', 'nexlifydesk'); ?></button>
                <button id="confirm-bulk-priority" class="button button-primary"><?php esc_html_e('Update', 'nexlifydesk'); ?></button>
            </div>
        </div>
    </div>

    <?php if (current_user_can('manage_options')): ?>
    <div id="bulk-delete-modal" class="bulk-modal" style="display: none;">
        <div class="modal-content">
            <h3 style="color: #d63638;"><?php esc_html_e('Delete Tickets', 'nexlifydesk'); ?></h3>
            <p><?php esc_html_e('Are you sure you want to permanently delete the selected tickets?', 'nexlifydesk'); ?></p>
            <div class="selected-tickets-info">
                <?php esc_html_e('This will delete', 'nexlifydesk'); ?> <strong><span id="selected-tickets-count">0</span></strong> <?php esc_html_e('tickets permanently.', 'nexlifydesk'); ?>
            </div>
            <p style="color: #d63638; font-weight: 600;"><?php esc_html_e('This action cannot be undone!', 'nexlifydesk'); ?></p>
            <div class="modal-actions">
                <button id="cancel-bulk-delete" class="button"><?php esc_html_e('Cancel', 'nexlifydesk'); ?></button>
                <button id="confirm-bulk-delete" class="button button-primary" style="background-color: #d63638; border-color: #d63638;"><?php esc_html_e('Delete Permanently', 'nexlifydesk'); ?></button>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>