<?php
if (!defined('ABSPATH')) {
    exit;
}

if (!$ticket) {
    echo '<div class="notice notice-error"><p>' . esc_html__('Ticket not found.', 'nexlifydesk') . '</p></div>';
    return;
}

$user = get_userdata($ticket->user_id);
$assigned_agent = $ticket->assigned_to ? get_userdata($ticket->assigned_to) : null;
$replies = NexlifyDesk_Tickets::get_replies($ticket->id);
$initial_attachments = NexlifyDesk_Tickets::get_attachments($ticket->id);
$user_avatar_url = $user ? get_avatar_url($user->ID) : get_avatar_url(0);

// Extract customer details for non-registered users
$customer_details = function_exists('nexlifydesk_extract_customer_details') ? 
    nexlifydesk_extract_customer_details($ticket->message) : 
    ['name' => '', 'email' => '', 'message' => $ticket->message];

$customer_name = $user ? $user->display_name : ($customer_details['name'] ?: 'Guest');
$customer_email = $user ? $user->user_email : ($customer_details['email'] ?: 'N/A');
$display_message = $customer_details['message'];
?>

<div class="nexlifydesk-admin-single-ticket-ui">
    <div class="ticket-container">
        <aside class="sidebar-left">
            <div class="sidebar-block">
                <label for="ticket-status"><?php esc_html_e('Status', 'nexlifydesk'); ?></label>
                <select id="ticket-status" class="ticket-status-select" data-ticket-id="<?php echo esc_attr($ticket->id); ?>">
                    <option value="open" <?php selected($ticket->status, 'open'); ?>><?php esc_html_e('Open', 'nexlifydesk'); ?></option>
                    <option value="in_progress" <?php selected($ticket->status, 'in_progress'); ?>><?php esc_html_e('In Progress', 'nexlifydesk'); ?></option>
                    <option value="pending" <?php selected($ticket->status, 'pending'); ?>><?php esc_html_e('Pending', 'nexlifydesk'); ?></option>
                    <option value="resolved" <?php selected($ticket->status, 'resolved'); ?>><?php esc_html_e('Resolved', 'nexlifydesk'); ?></option>
                    <option value="closed" <?php selected($ticket->status, 'closed'); ?>><?php esc_html_e('Closed', 'nexlifydesk'); ?></option>
                </select>
            </div>
            <div class="sidebar-block">
                <label for="ticket-priority"><?php esc_html_e('Priority', 'nexlifydesk'); ?></label>
                <select id="ticket-priority" disabled>
                    <option value="low" <?php selected($ticket->priority, 'low'); ?>><?php esc_html_e('Low', 'nexlifydesk'); ?></option>
                    <option value="medium" <?php selected($ticket->priority, 'medium'); ?>><?php esc_html_e('Medium', 'nexlifydesk'); ?></option>
                    <option value="high" <?php selected($ticket->priority, 'high'); ?>><?php esc_html_e('High', 'nexlifydesk'); ?></option>
                    <option value="urgent" <?php selected($ticket->priority, 'urgent'); ?>><?php esc_html_e('Urgent', 'nexlifydesk'); ?></option>
                </select>
            </div>
            <div class="sidebar-block">
                <label for="ticket-assignee"><?php esc_html_e('Assignee', 'nexlifydesk'); ?></label>
                <select id="ticket-assignee" class="ticket-agent-select" data-ticket-id="<?php echo esc_attr($ticket->id); ?>">
                    <option value="0"><?php esc_html_e('Unassigned', 'nexlifydesk'); ?></option>
                    <?php
                    $agents = get_users(['role__in' => ['administrator', 'nexlifydesk_agent'], 'orderby' => 'display_name']);
                    foreach ($agents as $agent) {
                        printf('<option value="%d" %s>%s</option>',
                            esc_attr($agent->ID),
                            selected($ticket->assigned_to, $agent->ID, false),
                            esc_html($agent->display_name)
                        );
                    }
                    ?>
                </select>
            </div>
            <div class="sidebar-block">
                <label for="ticket-tags"><?php esc_html_e('Tags', 'nexlifydesk'); ?></label>
                <div class="tags-input">
                    <span><?php esc_html_e('N/A', 'nexlifydesk'); ?></span>
                </div>
            </div>
        </aside>

        <main class="main-content">
            <header class="ticket-header">
                <h1>[#<?php echo esc_html($ticket->ticket_id); ?>] <?php echo esc_html($ticket->subject); ?></h1>
                <div class="requester-info">
                    <p><?php 
                        /* translators: 1: requester name, 2: date and time */
                        printf(esc_html__('Requested by %1$s on %2$s', 'nexlifydesk'), '<strong>' . esc_html($customer_name) . '</strong>', esc_html(date_i18n(get_option('date_format') . ' \a\t ' . get_option('time_format'), strtotime($ticket->created_at)))); 
                    ?></p>
                    <?php if (!$user && $customer_email !== 'N/A') : ?>
                        <p class="customer-email"><?php echo esc_html($customer_email); ?></p>
                    <?php endif; ?>
                </div>
            </header>

            <div class="response-area">
                <div class="tabs">
                    <button class="tab-link active" data-tab="reply"><?php esc_html_e('Reply', 'nexlifydesk'); ?></button>
                    <button class="tab-link" data-tab="note"><?php esc_html_e('Add Internal Note', 'nexlifydesk'); ?></button>
                    <!--<button class="tab-link" data-tab="order"><?php esc_html_e('Order Lookup', 'nexlifydesk'); ?></button>-->
                </div>

                <div id="reply" class="tab-content" style="display: block;">
                    <form id="nexlifydesk-reply-form" method="post" enctype="multipart/form-data">
                        <textarea name="message" required placeholder="<?php esc_attr_e('Type your public reply here...', 'nexlifydesk'); ?>"></textarea>
                        <div class="response-actions">
                            <button type="submit" class="btn btn-primary" id="admin-reply-btn">
                                <span class="button-text"><?php esc_html_e('Send Reply', 'nexlifydesk'); ?></span>
                                <span class="button-spinner" style="display: none;"></span>
                            </button>
                            <label for="reply-attachments" class="btn btn-secondary" style="margin-bottom:0;"><?php esc_html_e('Attach File', 'nexlifydesk'); ?></label>
                            <input type="file" name="attachments[]" id="reply-attachments" multiple style="display:none;">
                            <span class="file-info" style="margin-left:10px;"></span>
                            <div class="nexlifydesk-file-error" style="color:red;margin-top:5px;"></div>
                        </div>
                        <input type="hidden" name="action" value="nexlifydesk_add_reply">
                        <input type="hidden" name="ticket_id" value="<?php echo esc_attr($ticket->id); ?>">
                        <?php wp_nonce_field('nexlifydesk-ajax-nonce', 'nonce'); ?>
                    </form>
                </div>

                <div id="note" class="tab-content" style="display:none;">
                    <form id="nexlifydesk-note-form" method="post">
                        <div class="nexlifydesk-form-messages"></div>
                        <textarea name="note" placeholder="<?php esc_attr_e('Type your internal note here... (not visible to customer)', 'nexlifydesk'); ?>"></textarea>
                        <div class="response-actions">
                            <button type="submit" class="btn btn-primary" id="admin-note-btn"><?php esc_html_e('Add Note', 'nexlifydesk'); ?></button>
                        </div>
                        <input type="hidden" name="action" value="nexlifydesk_add_note">
                        <input type="hidden" name="ticket_id" value="<?php echo esc_attr($ticket->id); ?>">
                        <?php wp_nonce_field('nexlifydesk-ajax-nonce', 'nonce'); ?>
                    </form>
                </div>
            </div>

            <div class="conversation-history" id="nexlifydesk-replies-list">
                <div class="message customer-message">
                    <div class="message-avatar"><?php echo get_avatar($user ? $user->ID : 0, 48); ?></div>
                    <div class="message-content">
                        <div class="message-header">
                            <strong><?php echo esc_html($customer_name); ?></strong>
                            <span class="timestamp"><?php echo esc_html(date_i18n(get_option('date_format') . ' - ' . get_option('time_format'), strtotime($ticket->created_at))); ?></span>
                        </div>
                        <p><?php echo nl2br(esc_html($display_message)); ?></p>
                        <?php if (!empty($initial_attachments)) : ?>
                            <div class="attachments">
                                <ul class="attachments-list">
                                <?php foreach ($initial_attachments as $attachment) : ?>
                                    <li><a href="<?php echo esc_url($attachment->file_path); ?>" target="_blank" rel="noopener"><?php echo esc_html($attachment->file_name); ?></a></li>
                                <?php endforeach; ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <?php foreach ($replies as $reply) :
                    $reply_user = get_userdata($reply->user_id);
                    $is_agent_reply = $reply_user && (in_array('administrator', $reply_user->roles) || in_array('nexlifydesk_agent', $reply_user->roles));
                    $is_internal_note = isset($reply->is_internal_note) && $reply->is_internal_note;
                    
                    if (!$reply_user) {
                        // For non-registered customers
                        $reply_customer_details = function_exists('nexlifydesk_extract_customer_details') ? 
                            nexlifydesk_extract_customer_details($reply->message) : 
                            ['name' => '', 'email' => '', 'message' => $reply->message];
                        $reply_customer_name = $reply_customer_details['name'] ?: 'Guest';
                        $reply_display_message = $reply_customer_details['message'];
                    } else {
                        $reply_customer_name = $reply_user->display_name;
                        $reply_display_message = $reply->message;
                    }
                    
                    if ($is_internal_note) {
                        $message_class = 'internal-note';
                    } else {
                        $message_class = $is_agent_reply ? 'agent' : 'user';
                    }
                ?>
                <div class="message <?php echo esc_attr($message_class); ?>">
                    <div class="message-avatar"><?php echo get_avatar($reply_user ? $reply_user->ID : 0, 48); ?></div>
                    <div class="message-content">
                        <div class="message-header">
                            <strong><?php echo esc_html($reply_customer_name); ?></strong>
                            <?php if ($is_internal_note) : ?>
                                <span class="internal-note-label"><?php esc_html_e('Internal Note', 'nexlifydesk'); ?></span>
                            <?php endif; ?>
                            <span class="timestamp"><?php echo esc_html(date_i18n(get_option('date_format') . ' - ' . get_option('time_format'), strtotime($reply->created_at))); ?></span>
                        </div>
                        <p><?php echo nl2br(esc_html($reply_display_message)); ?></p>
                        <?php if (!empty($reply->attachments)) : ?>
                            <div class="attachments">
                                <ul class="attachments-list">
                                <?php foreach ($reply->attachments as $attachment) : ?>
                                    <li><a href="<?php echo esc_url($attachment->file_path); ?>" target="_blank" rel="noopener"><?php echo esc_html($attachment->file_name); ?></a></li>
                                <?php endforeach; ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </main>

        <aside class="sidebar-right">
            <div class="sidebar-block">
                <h3><?php esc_html_e('About Customer', 'nexlifydesk'); ?></h3>
                <p><strong><?php echo esc_html($customer_name); ?></strong></p>
                <p><?php echo esc_html($customer_email); ?></p>
                <?php if ($user): ?>
                    <a href="<?php echo esc_url(get_edit_user_link($user->ID)); ?>" target="_blank"><?php esc_html_e('View Profile', 'nexlifydesk'); ?></a>
                <?php elseif ($customer_email !== 'N/A'): ?>
                    <p class="non-registered-notice"><?php esc_html_e('Non-registered customer', 'nexlifydesk'); ?></p>
                <?php endif; ?>
            </div>
            <div class="sidebar-block">
                <h3><?php esc_html_e('Ticket Details', 'nexlifydesk'); ?></h3>
                <p><strong><?php esc_html_e('ID:', 'nexlifydesk'); ?></strong> #<?php echo esc_html($ticket->ticket_id); ?></p>
                <p><strong><?php esc_html_e('Created:', 'nexlifydesk'); ?></strong> <?php echo esc_html(date_i18n(get_option('date_format'), strtotime($ticket->created_at))); ?></p>
                <p><strong><?php esc_html_e('Channel:', 'nexlifydesk'); ?></strong> <?php
                    $channel_map = array(
                        'web' => __('Web', 'nexlifydesk'),
                        'chatbot' => __('Chatbot', 'nexlifydesk'),
                        'email' => __('Email', 'nexlifydesk'),
                    );
                    $source = !empty($ticket->source) ? strtolower($ticket->source) : 'web';
                    echo esc_html($channel_map[$source] ?? ucfirst($source));
                ?></p>
            </div>
            <div class="sidebar-block">
                <h3><?php esc_html_e('Attachments', 'nexlifydesk'); ?></h3>
                <ul class="attachments-list">
                    <?php
                    $all_attachments = array();
                    
                    if (!empty($initial_attachments) && is_array($initial_attachments)) {
                        $all_attachments = array_merge($all_attachments, $initial_attachments);
                    }
                    
                    if (!empty($replies) && is_array($replies)) {
                        foreach ($replies as $reply) {
                            if (isset($reply->attachments) && is_array($reply->attachments) && !empty($reply->attachments)) {
                                $all_attachments = array_merge($all_attachments, $reply->attachments);
                            }
                        }
                    }
                    
                    if (!empty($all_attachments)) {
                        foreach ($all_attachments as $attachment) {
                            if (isset($attachment->file_path) && isset($attachment->file_name)) {
                                echo '<li><a href="' . esc_url($attachment->file_path) . '" target="_blank" rel="noopener">' . esc_html($attachment->file_name) . '</a></li>';
                            }
                        }
                    } else {
                        echo '<li>' . esc_html__('No attachments found.', 'nexlifydesk') . '</li>';
                    }
                    ?>
                </ul>
            </div>
        </aside>
    </div>
</div>