<?php
if (!defined('ABSPATH')) {
    exit;
}

    $default_settings = array(
        'email_notifications' => 1,
        'admin_email_notifications' => 1,
        'default_priority' => 'medium',
        'auto_assign' => 0,
        'auto_assign_to_admin' => 0,
        'allowed_file_types' => 'jpg,jpeg,png,pdf',
        'max_file_size' => 2,
        'default_category' => 1,
        'sla_response_time' => 24,
        'ticket_page_id' => array(),
        'ticket_form_page_id' => array(),
        'ticket_id_prefix' => 'T',
        'ticket_id_start' => 1001,
        'keep_data_on_uninstall' => 1,
        'status_change_notification' => 1,
        'check_duplicates' => 1,
        'duplicate_threshold' => 80,
    );

    $settings = get_option('nexlifydesk_settings', $default_settings);

    $settings = array_merge($default_settings, array_filter($settings, function($key) use ($default_settings) {
        return array_key_exists($key, $default_settings);
    }, ARRAY_FILTER_USE_KEY));

    foreach ($settings as $key => $value) {
        if (in_array($key, array('default_priority', 'allowed_file_types', 'ticket_id_prefix',), true)) {
            $settings[$key] = sanitize_text_field($value);
        } elseif (in_array($key, array('max_file_size', 'default_category', 'sla_response_time', 'ticket_id_start', 'duplicate_threshold'), true)) {
            $settings[$key] = (int)$value;
        } elseif (in_array($key, array('ticket_page_id', 'ticket_form_page_id'), true)) {
            if (!is_array($value)) {
                $settings[$key] = $value ? array($value) : array();
            } else {
                $settings[$key] = array_map('intval', array_filter($value));
            }
        } elseif (in_array($key, array('check_duplicates', 'keep_data_on_uninstall'), true)) {
            $settings[$key] = $value ? 1 : 0;
        }
    }

    $categories = NexlifyDesk_Tickets::get_categories();
    $pages = get_pages();

    if (!is_array($categories)) {
        $categories = array();
    }
    if (!is_array($pages)) {
        $pages = array();
    }
?>

<div class="nexlifydesk-settings">
    <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
        <input type="hidden" name="action" value="nexlifydesk_save_settings">
        <?php wp_nonce_field('nexlifydesk_save_settings', 'nexlifydesk_settings_nonce'); ?>
        
        <h2><?php esc_html_e('General Settings', 'nexlifydesk'); ?></h2>
        <table class="form-table">
            <tr>
                <th><label for="email_notifications"><?php esc_html_e('Enable Email Notifications', 'nexlifydesk'); ?></label></th>
                <td>
                    <input type="checkbox" name="email_notifications" id="email_notifications" value="1" <?php checked($settings['email_notifications'], 1); ?>>
                    <p class="description"><?php esc_html_e('Send email notifications for new tickets, replies, and status changes.', 'nexlifydesk'); ?></p>
                </td>
            </tr>
            <tr>
                <th><label for="admin_email_notifications"><?php esc_html_e('Admin Email Notifications', 'nexlifydesk'); ?></label></th>
                <td>
                    <input type="checkbox" name="admin_email_notifications" id="admin_email_notifications" value="1" <?php checked($settings['admin_email_notifications'], 1); ?>>
                    <p class="description"><?php esc_html_e('Send email notifications to admin. When disabled, only assigned agents will receive notifications (except for SLA breach notifications).', 'nexlifydesk'); ?></p>
                </td>
            </tr>
            <tr>
                <th><label for="default_priority"><?php esc_html_e('Default Priority', 'nexlifydesk'); ?></label></th>
                <td>
                    <select name="default_priority" id="default_priority">
                        <option value="low" <?php selected($settings['default_priority'], 'low'); ?>><?php esc_html_e('Low', 'nexlifydesk'); ?></option>
                        <option value="medium" <?php selected($settings['default_priority'], 'medium'); ?>><?php esc_html_e('Medium', 'nexlifydesk'); ?></option>
                        <option value="high" <?php selected($settings['default_priority'], 'high'); ?>><?php esc_html_e('High', 'nexlifydesk'); ?></option>
                        <option value="urgent" <?php selected($settings['default_priority'], 'urgent'); ?>><?php esc_html_e('Urgent', 'nexlifydesk'); ?></option>
                    </select>
                    <p class="description"><?php esc_html_e('Default priority for new tickets.', 'nexlifydesk'); ?></p>
                </td>
            </tr>
            <tr>
                <th><label for="auto_assign"><?php esc_html_e('Auto-Assign Tickets', 'nexlifydesk'); ?></label></th>
                <td>
                    <input type="checkbox" name="auto_assign" id="auto_assign" value="1" <?php checked($settings['auto_assign'], 1); ?>>
                    <p class="description"><?php esc_html_e('Automatically assign new tickets to available support agents.', 'nexlifydesk'); ?></p>
                </td>
            </tr>
            <tr>
                <th><label for="auto_assign_to_admin"><?php esc_html_e('Auto-Assign Tickets to Admin', 'nexlifydesk'); ?></label></th>
                <td>
                    <input type="checkbox" name="auto_assign_to_admin" id="auto_assign_to_admin" value="1" <?php checked($settings['auto_assign_to_admin'] ?? 0, 1); ?>>
                    <p class="description"><?php esc_html_e('If no agent is available, assign tickets to an administrator automatically.', 'nexlifydesk'); ?></p>
                </td>
            </tr>
            <tr>
                <th><label for="ticket_page_id"><?php esc_html_e('Ticket List Pages', 'nexlifydesk'); ?></label></th>
                <td>
                    <select name="ticket_page_id[]" id="ticket_page_id" multiple="multiple" style="width: 100%; height: 120px;">
                        <?php if (!empty($pages) && is_array($pages)): ?>
                            <?php 
                            $selected_pages = isset($settings['ticket_page_id']) ? $settings['ticket_page_id'] : array();
                            if (!is_array($selected_pages)) {
                                $selected_pages = $selected_pages ? array($selected_pages) : array();
                            }
                            ?>
                            <?php foreach ($pages as $page): ?>
                                <?php if (isset($page->ID) && isset($page->post_title)): ?>
                                    <option value="<?php echo esc_attr((int)$page->ID); ?>" <?php echo in_array((int)$page->ID, array_map('intval', $selected_pages)) ? 'selected' : ''; ?>>
                                        <?php echo esc_html(wp_strip_all_tags($page->post_title)); ?>
                                    </option>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <option value="0"><?php esc_html_e('No pages available', 'nexlifydesk'); ?></option>
                        <?php endif; ?>
                    </select>
                    <p class="description">
                        <?php esc_html_e('Select one or more pages where the ticket list shortcode [nexlifydesk_ticket_list] should render the actual ticket list. Hold Ctrl (Windows) or Cmd (Mac) to select multiple pages.', 'nexlifydesk'); ?><br>
                        <strong><?php esc_html_e('Note:', 'nexlifydesk'); ?></strong> <?php esc_html_e('On pages not selected here, the shortcode will display as plain text for documentation purposes.', 'nexlifydesk'); ?>
                    </p>
                </td>
            </tr>
            <tr>
                <th><label for="ticket_form_page_id"><?php esc_html_e('Ticket Form Pages', 'nexlifydesk'); ?></label></th>
                <td>
                    <select name="ticket_form_page_id[]" id="ticket_form_page_id" multiple="multiple" style="width: 100%; height: 120px;">
                        <?php if (!empty($pages) && is_array($pages)): ?>
                            <?php 
                            $selected_form_pages = isset($settings['ticket_form_page_id']) ? $settings['ticket_form_page_id'] : array();
                            if (!is_array($selected_form_pages)) {
                                $selected_form_pages = $selected_form_pages ? array($selected_form_pages) : array();
                            }
                            ?>
                            <?php foreach ($pages as $page): ?>
                                <?php if (isset($page->ID) && isset($page->post_title)): ?>
                                    <option value="<?php echo esc_attr((int)$page->ID); ?>" <?php echo in_array((int)$page->ID, array_map('intval', $selected_form_pages)) ? 'selected' : ''; ?>>
                                        <?php echo esc_html(wp_strip_all_tags($page->post_title)); ?>
                                    </option>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <option value="0"><?php esc_html_e('No pages available', 'nexlifydesk'); ?></option>
                        <?php endif; ?>
                    </select>
                    <p class="description">
                        <?php esc_html_e('Select one or more pages where the ticket form shortcode [nexlifydesk_ticket_form] should render the actual form. Hold Ctrl (Windows) or Cmd (Mac) to select multiple pages.', 'nexlifydesk'); ?><br>
                        <strong><?php esc_html_e('Note:', 'nexlifydesk'); ?></strong> <?php esc_html_e('On pages not selected here, the shortcode will display as plain text for documentation purposes.', 'nexlifydesk'); ?>
                    </p>
                </td>
            </tr>
            <tr>
                <th><label for="status_change_notification"><?php esc_html_e('Send Status Change Notification', 'nexlifydesk'); ?></label></th>
                <td>
                    <input type="checkbox" name="status_change_notification" id="status_change_notification" value="1" <?php checked($settings['status_change_notification'] ?? 1, 1); ?>>
                    <p class="description"><?php esc_html_e('Send an email notification to the user when the ticket status changes.', 'nexlifydesk'); ?></p>
                </td>
            </tr>
            <tr>
                <th><label for="ticket_id_prefix"><?php esc_html_e('Ticket ID Prefix', 'nexlifydesk'); ?></label></th>
                <td>
                    <input type="text" name="ticket_id_prefix" id="ticket_id_prefix" class="regular-text" value="<?php echo esc_attr($settings['ticket_id_prefix'] ?? 'T'); ?>">
                    <p class="description"><?php esc_html_e('Prefix for ticket IDs (e.g., T, #, TKT-).', 'nexlifydesk'); ?></p>
                </td>
            </tr>
            <tr>
                <th><label for="ticket_id_start"><?php esc_html_e('Ticket ID Start Number', 'nexlifydesk'); ?></label></th>
                <td>
                    <input type="number" name="ticket_id_start" id="ticket_id_start" min="1" value="<?php echo esc_attr($settings['ticket_id_start'] ?? 1001); ?>">
                    <p class="description"><?php esc_html_e('The number to start ticket IDs from (e.g., 1001). Only used if no tickets exist yet.', 'nexlifydesk'); ?></p>
                </td>
            </tr>
            <tr>
                <th><label for="keep_data_on_uninstall"><?php esc_html_e('Data Retention on Uninstall', 'nexlifydesk'); ?></label></th>
                <td>
                    <input type="checkbox" name="keep_data_on_uninstall" id="keep_data_on_uninstall" value="1" <?php checked($settings['keep_data_on_uninstall'] ?? 1, 1); ?>>
                    <label for="keep_data_on_uninstall" style="margin-left: 8px;"><?php esc_html_e('Keep all tickets and data when plugin is uninstalled', 'nexlifydesk'); ?></label>
                    <p class="description">
                        <strong><?php esc_html_e('Recommended: Keep enabled', 'nexlifydesk'); ?></strong><br>
                        <?php esc_html_e('When enabled, all tickets, replies, attachments, and customer data will be preserved even after plugin deletion. Disable only if you want to completely remove all plugin data during uninstall.', 'nexlifydesk'); ?>
                    </p>
                    <div id="data-deletion-warning" style="margin-top: 10px; padding: 10px; background: #fef2f2; border: 1px solid #fecaca; border-radius: 4px; display: none;">
                        <p style="color: #dc2626; margin: 0; font-weight: 600;">
                            ⚠️ <?php esc_html_e('Warning: Unchecking this option will permanently delete ALL ticket data when the plugin is uninstalled!', 'nexlifydesk'); ?>
                        </p>
                        <p style="color: #dc2626; margin: 5px 0 0 0; font-size: 0.9em;">
                            <?php esc_html_e('This includes: All tickets, customer replies, agent responses, attachments, categories, and support history.', 'nexlifydesk'); ?>
                        </p>
                    </div>
                </td>
            </tr>
        </table>

        <h2><?php esc_html_e('File Upload Settings', 'nexlifydesk'); ?></h2>
        <table class="form-table">
            <tr>
                <th><label for="allowed_file_types"><?php esc_html_e('Allowed File Types', 'nexlifydesk'); ?></label></th>
                <td>
                    <input type="text" name="allowed_file_types" id="allowed_file_types" class="regular-text" value="<?php echo esc_attr($settings['allowed_file_types']); ?>">
                    <p class="description"><?php esc_html_e('Comma-separated list of allowed file extensions (e.g., jpg,png,pdf).', 'nexlifydesk'); ?></p>
                </td>
            </tr>
            <tr>
                <th><label for="max_file_size"><?php esc_html_e('Maximum File Size (MB)', 'nexlifydesk'); ?></label></th>
                <td>
                    <input type="number" name="max_file_size" id="max_file_size" min="1" max="100" value="<?php echo esc_attr($settings['max_file_size']); ?>">
                    <p class="description"><?php esc_html_e('Maximum size for uploaded files in megabytes.', 'nexlifydesk'); ?></p>
                </td>
            </tr>
        </table>

        <h2><?php esc_html_e('SLA Settings', 'nexlifydesk'); ?></h2>
        <table class="form-table">
            <tr>
                <th><label for="sla_response_time"><?php esc_html_e('SLA Response Time (Hours)', 'nexlifydesk'); ?></label></th>
                <td>
                    <input type="number" name="sla_response_time" id="sla_response_time" min="1" max="168" value="<?php echo esc_attr($settings['sla_response_time']); ?>">
                    <p class="description"><?php esc_html_e('Expected response time for tickets (in hours).', 'nexlifydesk'); ?></p>
                </td>
            </tr>
            <tr>
                <th><label for="default_category"><?php esc_html_e('Default Category', 'nexlifydesk'); ?></label></th>
                <td>
                    <select name="default_category" id="default_category">
                        <?php if (!empty($categories) && is_array($categories)): ?>
                            <?php foreach ($categories as $category): ?>
                                <?php if (isset($category->id) && isset($category->name)): ?>
                                    <option value="<?php echo esc_attr((int)$category->id); ?>" <?php selected((int)$settings['default_category'], (int)$category->id); ?>>
                                        <?php echo esc_html(wp_strip_all_tags($category->name)); ?>
                                    </option>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <option value="0"><?php esc_html_e('No categories available', 'nexlifydesk'); ?></option>
                        <?php endif; ?>
                    </select>
                    <p class="description"><?php esc_html_e('Default category for new tickets.', 'nexlifydesk'); ?></p>
                </td>
            </tr>
        </table>

        <h2><?php esc_html_e('Duplicate Detection Settings', 'nexlifydesk'); ?></h2>
        <table class="form-table">
            <tr>
                <th><label for="check_duplicates"><?php esc_html_e('Enable Duplicate Detection', 'nexlifydesk'); ?></label></th>
                <td>
                    <input type="checkbox" name="check_duplicates" id="check_duplicates" value="1" <?php checked($settings['check_duplicates'] ?? 1, 1); ?>>
                    <p class="description"><?php esc_html_e('Automatically check for duplicate tickets and add new messages as replies to existing tickets.', 'nexlifydesk'); ?></p>
                </td>
            </tr>
            <tr>
                <th><label for="duplicate_threshold"><?php esc_html_e('Similarity Threshold (%)', 'nexlifydesk'); ?></label></th>
                <td>
                    <input type="number" name="duplicate_threshold" id="duplicate_threshold" min="50" max="100" value="<?php echo esc_attr($settings['duplicate_threshold'] ?? 80); ?>">
                    <p class="description"><?php esc_html_e('Percentage of keyword similarity required to consider a ticket as duplicate (50-100%).', 'nexlifydesk'); ?></p>
                </td>
            </tr>
        </table>

        <h2><?php esc_html_e('Spam Protection', 'nexlifydesk'); ?></h2>
        <table class="form-table">
            <tr>
                <th><label for=""><?php esc_html_e('Rate Limiting', 'nexlifydesk'); ?></label></th>
                <td>
                    <p class="description"><?php esc_html_e('Prevents spam by limiting ticket creation to 5 tickets per 30 minutes per user/email address.', 'nexlifydesk'); ?></p>
                    <p class="description"><?php esc_html_e('This applies to both web submissions and email piping. Admin and agent users are exempt from rate limiting.', 'nexlifydesk'); ?></p>
                </td>
            </tr>
            <tr>
                <th><label for=""><?php esc_html_e('Clear Rate Limits', 'nexlifydesk'); ?></label></th>
                <td>
                    <p class="description"><?php esc_html_e('Remove rate limiting restrictions for a specific user or email address.', 'nexlifydesk'); ?></p>
                    <div style="margin-top: 10px;">
                        <input type="email" id="nexlifydesk_clear_rate_limit_email" placeholder="<?php esc_attr_e('Enter email address', 'nexlifydesk'); ?>" style="width: 300px;">
                        <button type="button" class="button" id="nexlifydesk_clear_rate_limit"><?php esc_html_e('Clear Rate Limit', 'nexlifydesk'); ?></button>
                    </div>
                    <div id="nexlifydesk_clear_rate_limit_result" style="margin-top: 10px;"></div>
                </td>
            </tr>
            <tr>
                <th><label for=""><?php esc_html_e('Rate Limit Status', 'nexlifydesk'); ?></label></th>
                <td>
                    <p class="description"><?php esc_html_e('Check the current rate limit status for a specific user or email address.', 'nexlifydesk'); ?></p>
                    <div style="margin-top: 10px;">
                        <input type="email" id="nexlifydesk_check_rate_limit_email" placeholder="<?php esc_attr_e('Enter email address', 'nexlifydesk'); ?>" style="width: 300px;">
                        <button type="button" class="button" id="nexlifydesk_check_rate_limit"><?php esc_html_e('Check Status', 'nexlifydesk'); ?></button>
                    </div>
                    <div id="nexlifydesk_check_rate_limit_result" style="margin-top: 10px;"></div>
                </td>
            </tr>
        </table>

        <h2><?php esc_html_e('Data Management', 'nexlifydesk'); ?></h2>
        <table class="form-table">
            <tr>
                <th><label for=""><?php esc_html_e('Purge Data', 'nexlifydesk'); ?></label></th>
                <td>
                    <p class="description"><?php esc_html_e('Remove old or unnecessary data to free up space and improve performance.', 'nexlifydesk'); ?></p>
                    <button type="button" class="button" id="nexlifydesk_purge_data"><?php esc_html_e('Purge Data', 'nexlifydesk'); ?></button>
                    <div id="nexlifydesk_purge_data_result" style="margin-top: 10px;"></div>
                </td>
            </tr>
        </table>

        <p class="submit">
            <input type="submit" name="nexlifydesk_settings_save" class="button button-primary" value="<?php esc_html_e('Save Settings', 'nexlifydesk'); ?>">
        </p>
    </form>
</div>

<script type="text/javascript">
jQuery(document).ready(function($) {
    // Handle data retention warning
    $('#keep_data_on_uninstall').on('change', function() {
        if (!this.checked) {
            $('#data-deletion-warning').show();
        } else {
            $('#data-deletion-warning').hide();
        }
    });

    if (!$('#keep_data_on_uninstall').is(':checked')) {
        $('#data-deletion-warning').show();
    }
});
</script>