<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$stats = NexlifyDesk_Reports::get_dashboard_stats();
?>

<div class="nexlifydesk-reports-dashboard nexlifydesk-reports-page-ui">
    <div class="reports-header">
        <?php // phpcs:ignore PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage -- Plugin asset image, not media library image ?>
        <img src="<?php echo esc_url( NEXLIFYDESK_PLUGIN_URL . 'assets/images/nexlifydesk-logo.png' ); ?>" 
             alt="<?php esc_attr_e( 'NexlifyDesk', 'nexlifydesk' ); ?>" 
             class="nexlifydesk-logo-img">
        <div>
            <h2><?php esc_html_e( 'NexlifyDesk Reports', 'nexlifydesk' ); ?></h2>
            <p><?php esc_html_e( 'Performance analytics and support metrics', 'nexlifydesk' ); ?></p>
        </div>
    </div>

    <div class="reports-container">
        <div class="date-filter">
            <select id="report-date-range">
                <option value="7"><?php esc_html_e( 'Last 7 Days', 'nexlifydesk' ); ?></option>
                <option value="30" selected><?php esc_html_e( 'Last 30 Days', 'nexlifydesk' ); ?></option>
                <option value="90"><?php esc_html_e( 'Last 90 Days', 'nexlifydesk' ); ?></option>
                <option value="365"><?php esc_html_e( 'Last Year', 'nexlifydesk' ); ?></option>
            </select>
        </div>

        <!-- Key Metrics Cards -->
        <div class="metrics-grid">
            <div class="metric-card">
                <div class="metric-label"><?php esc_html_e( 'Total Tickets', 'nexlifydesk' ); ?></div>
                <div class="metric-value"><?php echo esc_html( $stats['total_tickets'] ); ?></div>
                <div class="metric-trend trend-up">+5% <?php esc_html_e( 'from last period', 'nexlifydesk' ); ?></div>
            </div>
            <div class="metric-card">
                <div class="metric-label"><?php esc_html_e( 'Active Tickets', 'nexlifydesk' ); ?></div>
                <div class="metric-value"><?php echo esc_html( $stats['active_tickets'] ); ?></div>
                <div class="metric-trend trend-down">-3% <?php esc_html_e( 'from last period', 'nexlifydesk' ); ?></div>
            </div>
            <div class="metric-card">
                <div class="metric-label"><?php esc_html_e( 'Closed Tickets', 'nexlifydesk' ); ?></div>
                <div class="metric-value"><?php echo esc_html( $stats['closed_tickets'] ); ?></div>
                <div class="metric-trend trend-up">+12% <?php esc_html_e( 'from last period', 'nexlifydesk' ); ?></div>
            </div>
            <div class="metric-card">
                <div class="metric-label"><?php esc_html_e( 'Avg Response Time', 'nexlifydesk' ); ?></div>
                <div class="metric-value"><?php echo esc_html( $stats['avg_response_time'] ); ?></div>
                <div class="metric-trend trend-up">+8% <?php esc_html_e( 'from last period', 'nexlifydesk' ); ?></div>
            </div>
        </div>

        <!-- Charts Section -->
        <div class="charts-grid">
            <!-- Status Distribution Chart -->
            <div class="chart-container">
                <h3><?php esc_html_e( 'Ticket Status Distribution', 'nexlifydesk' ); ?></h3>
                <div class="chart-wrapper">
                    <canvas id="statusChart" width="250" height="250"></canvas>
                    <div class="chart-legend">
                        <?php foreach ( $stats['status_breakdown'] as $status => $count ) : ?>
                            <div class="legend-item">
                                <span class="legend-color status-<?php echo esc_attr( $status ); ?>"></span>
                                <span><?php echo esc_html( ucfirst( $status ) ); ?>: <?php echo esc_html( $count ); ?></span>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>

            <!-- Priority Distribution Chart -->
            <div class="chart-container">
                <h3><?php esc_html_e( 'Priority Distribution', 'nexlifydesk' ); ?></h3>
                <div class="chart-wrapper">
                    <canvas id="priorityChart" width="250" height="250"></canvas>
                    <div class="chart-legend">
                        <?php foreach ( $stats['priority_breakdown'] as $priority => $count ) : ?>
                            <div class="legend-item">
                                <span class="legend-color priority-<?php echo esc_attr( $priority ); ?>"></span>
                                <span><?php echo esc_html( ucfirst( $priority ) ); ?>: <?php echo esc_html( $count ); ?></span>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>

            <!-- Monthly Tickets Chart -->
            <div class="chart-container full-width">
                <h3><?php esc_html_e( 'Tickets This Month', 'nexlifydesk' ); ?></h3>
                <div class="chart-wrapper">
                    <canvas id="monthlyChart" width="800" height="250"></canvas>
                </div>
            </div>
        </div>

        <!-- Agent Performance Table -->
        <div class="agent-performance">
            <h3><?php esc_html_e( 'Agent Performance', 'nexlifydesk' ); ?></h3>
            <table>
                <thead>
                    <tr>
                        <th><?php esc_html_e( 'Agent', 'nexlifydesk' ); ?></th>
                        <th><?php esc_html_e( 'Assigned', 'nexlifydesk' ); ?></th>
                        <th><?php esc_html_e( 'Closed', 'nexlifydesk' ); ?></th>
                        <th><?php esc_html_e( 'Response Rate', 'nexlifydesk' ); ?></th>
                        <th><?php esc_html_e( 'Avg Response', 'nexlifydesk' ); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ( $stats['agent_performance'] as $agent ) : ?>
                        <tr>
                            <td class="agent-name"><?php echo esc_html( $agent['name'] ); ?></td>
                            <td><?php echo esc_html( $agent['assigned'] ); ?></td>
                            <td><?php echo esc_html( $agent['closed'] ); ?></td>
                            <td><span class="response-rate-value"><?php echo esc_html( $agent['response_rate'] ); ?>%</span></td>
                            <td><?php echo esc_html( $agent['avg_response_time'] ); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Recent Activity -->
        <div class="recent-activity">
            <h3><?php esc_html_e( 'Recent Activity', 'nexlifydesk' ); ?></h3>
            <div class="activity-list">
                <?php foreach ( $stats['recent_activity'] as $activity ) : ?>
                    <div class="activity-item">
                        <div class="activity-icon status-<?php echo esc_attr( $activity['type'] ); ?>"></div>
                        <div class="activity-content">
                            <div class="activity-text"><?php echo wp_kses_post( $activity['message'] ); ?></div>
                            <div class="activity-time"><?php echo esc_html( $activity['time'] ); ?></div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>