<?php
if (!defined('ABSPATH')) {
    exit;
}

if (!isset($note_obj) || !is_object($note_obj)) {
    return;
}

$reply_user = get_userdata($note_obj->user_id);
$is_agent_reply = $reply_user && (in_array('administrator', $reply_user->roles) || in_array('nexlifydesk_agent', $reply_user->roles));
$is_internal_note = isset($note_obj->is_internal_note) && $note_obj->is_internal_note;

if ($is_internal_note) {
    $message_class = 'internal-note';
} else {
    $message_class = $is_agent_reply ? 'agent' : 'user';
}
?>
<div class="message <?php echo esc_attr($message_class); ?>">
    <div class="message-avatar"><?php echo get_avatar($reply_user ? $reply_user->ID : 0, 48); ?></div>
    <div class="message-content">
        <div class="message-header">
            <strong><?php echo esc_html($reply_user ? $reply_user->display_name : 'User'); ?></strong>
            <?php if ($is_internal_note) : ?>
                <span class="internal-note-label"><?php esc_html_e('Internal Note', 'nexlifydesk'); ?></span>
            <?php endif; ?>
            <span class="timestamp"><?php echo esc_html(date_i18n(get_option('date_format') . ' - ' . get_option('time_format'), strtotime($note_obj->created_at))); ?></span>
        </div>
        <p><?php echo nl2br(esc_html($note_obj->message)); ?></p>
        <?php if (!empty($note_obj->attachments)) : ?>
            <div class="attachments">
                <ul class="attachments-list">
                <?php foreach ($note_obj->attachments as $attachment) : ?>
                    <li><a href="<?php echo esc_url($attachment->file_path); ?>" target="_blank" rel="noopener"><?php echo esc_html($attachment->file_name); ?></a></li>
                <?php endforeach; ?>
                </ul>
            </div>
        <?php endif; ?>
    </div>
</div>
