<?php
if (!defined('ABSPATH')) exit;


$imap_settings = get_option('nexlifydesk_imap_settings', array(
    'host' => '',
    'port' => 993,
    'username' => '',
    'password' => '',
    'encryption' => 'ssl',
    'enabled' => 0,
    'provider' => 'custom',
    'protocol' => 'imap',
    'fetch_interval' => 5,
    'delete_emails_after_fetch' => 1,
    'google_client_id' => '',
    'google_client_secret' => '',
    'google_auth_status' => '',
    'google_refresh_token' => '',
    'google_account_email' => '',
    'block_admin_emails' => 1,
    'block_notification_subjects' => 1,
    'block_marketing_emails' => 1,
    'blocked_emails' => '',
    'blocked_domains' => '',
    'spam_url_filtering' => 1,
    'max_links_per_email' => 3,
    'blocked_keywords' => '',
));

if (!isset($imap_settings['google_auth_status']) || $imap_settings['google_auth_status'] === null) {
    $imap_settings['google_auth_status'] = '';
}

$provider = $imap_settings['provider'] ?? 'custom';
$redirect_uri = admin_url('admin.php?action=nexlifydesk_google_oauth_callback');
$auth_url = wp_nonce_url(admin_url('admin.php?action=nexlifydesk_google_auth_init'), 'google-auth-init');

// SSL detection
$is_ssl_enabled = function_exists('nexlifydesk_check_ssl_enabled') ? nexlifydesk_check_ssl_enabled() : is_ssl();

$auth_message = '';
if (isset($_GET['auth']) && isset($_GET['_wpnonce']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['_wpnonce'])), 'nexlifydesk_imap_auth')) {
    switch ($_GET['auth']) {
        case 'success':
            $auth_message = '<div class="notice notice-success"><p>' . esc_html__('Successfully authorized with Google!', 'nexlifydesk') . '</p></div>';
            break;
        case 'failed':
            $auth_message = '<div class="notice notice-error"><p>' . esc_html__('Google authorization failed. Please try again.', 'nexlifydesk') . '</p></div>';
            break;
    }
}

if (isset($_GET['deauth'])) {
    switch ($_GET['deauth']) {
        case 'google_success':
            $auth_message = '<div class="notice notice-success"><p>' . esc_html__('Google credentials have been successfully cleared.', 'nexlifydesk') . '</p></div>';
            break;
        case 'aws_success':
            $auth_message = '<div class="notice notice-success"><p>' . esc_html__('AWS WorkMail credentials have been successfully cleared.', 'nexlifydesk') . '</p></div>';
            break;
        case 'custom_success':
            $auth_message = '<div class="notice notice-success"><p>' . esc_html__('Custom IMAP/POP3 credentials have been successfully cleared.', 'nexlifydesk') . '</p></div>';
            break;
        case 'all_success':
            $auth_message = '<div class="notice notice-success"><p>' . esc_html__('All email provider credentials have been successfully cleared.', 'nexlifydesk') . '</p></div>';
            break;
    }
}
?>
<?php echo wp_kses_post($auth_message); ?>
<form method="post" action="options.php">
    <?php settings_fields('nexlifydesk_settings'); ?>
    <table class="form-table">
        <tr>
            <th><label for="enabled"><?php esc_html_e('Enable Email Piping', 'nexlifydesk'); ?></label></th>
            <td><input type="checkbox" name="nexlifydesk_imap_settings[enabled]" id="enabled" value="1" <?php checked($imap_settings['enabled'], 1); ?>></td>
        </tr>
        <tr>
            <th><label for="fetch_interval"><?php esc_html_e('Auto Fetch Interval', 'nexlifydesk'); ?></label></th>
            <td>
                <select name="nexlifydesk_imap_settings[fetch_interval]" id="fetch_interval">
                    <option value="2" <?php selected($imap_settings['fetch_interval'] ?? 5, 2); ?>>Every 2 Minutes</option>
                    <option value="5" <?php selected($imap_settings['fetch_interval'] ?? 5, 5); ?>>Every 5 Minutes</option>
                    <option value="10" <?php selected($imap_settings['fetch_interval'] ?? 5, 10); ?>>Every 10 Minutes</option>
                    <option value="15" <?php selected($imap_settings['fetch_interval'] ?? 5, 15); ?>>Every 15 Minutes</option>
                </select>
                <p class="description"><?php esc_html_e('How often to automatically check for new emails and create tickets.', 'nexlifydesk'); ?></p>
            </td>
        </tr>
        <tr>
            <th><label for="delete_emails_after_fetch"><?php esc_html_e('Delete Emails After Fetch', 'nexlifydesk'); ?></label></th>
            <td>
                <input type="checkbox" name="nexlifydesk_imap_settings[delete_emails_after_fetch]" id="delete_emails_after_fetch" value="1" <?php checked($imap_settings['delete_emails_after_fetch'] ?? 1, 1); ?>>
                <p class="description"><?php esc_html_e('Whether to delete emails from the server after processing them into tickets. Unchecking this will leave emails in the inbox.', 'nexlifydesk'); ?></p>
            </td>
        </tr>
        <tr>
            <th><label for="provider">Email Provider</label></th>
            <td>
                <select name="nexlifydesk_imap_settings[provider]" id="provider-select">
                    <option value="custom" <?php selected($provider, 'custom'); ?>>Custom IMAP/POP3</option>
                    <option value="google" <?php selected($provider, 'google'); ?>>Google / Gmail</option>
                    <option value="aws" <?php selected($provider, 'aws'); ?>>AWS WorkMail</option>
                </select>
            </td>
        </tr>

        <tbody id="google-settings" class="provider-settings" style="display: <?php echo $provider === 'google' ? 'table-row-group' : 'none'; ?>;">
            <tr>
                <td colspan="2">
                    <p class="description"><?php esc_html_e('Follow the setup guide to get your Google API credentials.', 'nexlifydesk'); ?></p>
                    <p><strong><?php esc_html_e('Authorized Redirect URI:', 'nexlifydesk'); ?></strong></p>
                    <p><code><?php echo esc_html($redirect_uri); ?></code></p>
                    <p class="description"><?php esc_html_e('Copy this URI and paste it into the "Authorized redirect URIs" field in your Google Cloud Console project.', 'nexlifydesk'); ?></p>
                </td>
            </tr>
            <tr>
                <th><label for="google_client_id">Client ID</label></th>
                <td><input type="text" name="nexlifydesk_imap_settings[google_client_id]" id="google_client_id" value="<?php echo esc_attr($imap_settings['google_client_id'] ?? ''); ?>" class="regular-text"></td>
            </tr>
            <tr>
                <th><label for="google_client_secret">Client Secret</label></th>
                <td>
                    <?php if (!empty($imap_settings['google_client_secret'])): ?>
                        <input type="password" name="nexlifydesk_imap_settings[google_client_secret]" id="google_client_secret" value="••••••••••••••••" disabled style="background-color: #f7f7f7; border: 1px solid #ddd; cursor: not-allowed;" class="regular-text">
                        <input type="hidden" name="nexlifydesk_imap_settings[google_client_secret_preserved]" value="1" id="google-secret-preserved-flag">
                        <button type="button" id="edit-google-secret" class="button" style="margin-left: 5px;">Edit Secret</button>
                        <p class="description">Client Secret is saved and encrypted. Click "Edit Secret" to change it.</p>
                    <?php else: ?>
                        <input type="password" name="nexlifydesk_imap_settings[google_client_secret]" id="google_client_secret" value="" placeholder="Enter client secret" class="regular-text">
                        <p class="description">Enter your Google API client secret.</p>
                    <?php endif; ?>
                </td>
            </tr>
            <tr>
                <th>Authorization</th>
                <td>
                    <?php if (!empty($imap_settings['google_refresh_token'])): ?>
                         <p style="color: green;">✅ Successfully authorized with Google.</p>
                         <p><strong>Authorized Account:</strong> <?php echo esc_html($imap_settings['google_account_email'] ?? 'Unknown'); ?></p>
                         
                         <?php if (!empty($imap_settings['google_fetch_start_time'])): ?>
                             <p><strong>Email Fetch Start Time:</strong> <?php echo esc_html(gmdate('Y-m-d H:i:s', $imap_settings['google_fetch_start_time'])); ?></p>
                             <p class="description">Only emails received after this time will be processed to avoid creating tickets from old emails.</p>
                         <?php endif; ?>
                         
                         <p>
                             <a href="<?php echo esc_url($auth_url); ?>" class="button">Re-authorize</a>
                             <a href="<?php echo esc_url(wp_nonce_url(admin_url('admin-post.php?action=nexlifydesk_deauth_google'), 'nexlifydesk_deauth_google')); ?>" class="button button-secondary" onclick="return confirm('Are you sure you want to clear Google credentials? This will disable Google email fetching.');">Clear Credentials</a>
                         </p>
                         <p class="description"><?php esc_html_e('Click "Re-authorize" to change the Gmail account or refresh permissions. Click "Clear Credentials" to remove stored authentication data.', 'nexlifydesk'); ?></p>
                    <?php else: ?>
                        <a href="<?php echo esc_url($auth_url); ?>" class="button button-primary">Authorize with Google</a>
                        <p class="description"><?php esc_html_e('You will be prompted to select which Gmail account to use for email piping.', 'nexlifydesk'); ?></p>
                        <?php if (!empty($imap_settings['google_auth_status']) && strpos((string)$imap_settings['google_auth_status'], 'failed') !== false): ?>
                            <p style="color: red;"><?php echo esc_html($imap_settings['google_auth_status']); ?></p>
                        <?php endif; ?>
                    <?php endif; ?>
                </td>
            </tr>
            <tr>
                <th>Connection Test</th>
                <td>
                    <button type="button" id="test-google-connection" class="button">Test Google Connection</button>
                    <button type="button" id="test-google-fetch-emails" class="button button-secondary" style="margin-left: 10px;">Test Email Fetch</button>
                    <div id="google-connection-result" style="margin-top: 10px;"></div>
                    <div id="google-fetch-result" style="margin-top: 10px;"></div>
                    <p class="description"><?php esc_html_e('Test the connection to Google Gmail and manually fetch emails for testing.', 'nexlifydesk'); ?></p>
                </td>
            </tr>
        </tbody>

        <tbody id="aws-settings" class="provider-settings" style="display: <?php echo $provider === 'aws' ? 'table-row-group' : 'none'; ?>;">
            <tr>
                <td colspan="2">
                    <div class="notice notice-info inline" style="margin: 0; padding: 12px;">
                        <p><strong><?php esc_html_e('AWS Email Integration Options', 'nexlifydesk'); ?></strong></p>
                        <p><strong>Option 1 - IMAP (Traditional):</strong> Organization ID, Email Address, and Email Password required.</p>
                        <p><strong>Option 2 - Lambda (Coming Soon):</strong> Real-time email processing via AWS SES + Lambda webhook will be available in a future update.</p>
                        <p>AWS Access Key ID and Secret Access Key are optional for enhanced SES features.</p>
                    </div>
                </td>
            </tr>
            <tr>
                <th>SSL Status</th>
                <td>
                    <?php 
                    $ssl_enabled = function_exists('nexlifydesk_check_ssl_enabled') ? nexlifydesk_check_ssl_enabled() : is_ssl();
                    if ($ssl_enabled): ?>
                        <span style="color: green;">✅ SSL/HTTPS is enabled</span>
                        <p class="description"><?php esc_html_e('Your site is running on HTTPS, which is required for AWS WorkMail integration.', 'nexlifydesk'); ?></p>
                    <?php else: ?>
                        <span style="color: red;">❌ SSL/HTTPS is required</span>
                        <div class="notice notice-error inline" style="margin: 5px 0; padding: 8px;">
                            <p><strong><?php esc_html_e('SSL Certificate Required', 'nexlifydesk'); ?></strong></p>
                            <p><?php esc_html_e('AWS WorkMail integration requires your WordPress site to run on HTTPS. Please install an SSL certificate and configure your site to use HTTPS.', 'nexlifydesk'); ?></p>
                        </div>
                    <?php endif; ?>
                </td>
            </tr>
            <tr>
                <th><label for="aws_integration_type">Integration Type</label></th>
                <td>
                    <select name="nexlifydesk_imap_settings[aws_integration_type]" id="aws_integration_type" <?php echo !$is_ssl_enabled ? 'disabled' : ''; ?>>
                        <option value="imap" <?php selected($imap_settings['aws_integration_type'] ?? 'imap', 'imap'); ?>>IMAP (Traditional)</option>
                        <option value="lambda" <?php selected($imap_settings['aws_integration_type'] ?? '', 'lambda'); ?> disabled>Lambda + SES (Coming Soon)</option>
                    </select>
                    <p class="description"><?php esc_html_e('Currently only IMAP integration is available. Lambda webhook integration will be available in a future update after thorough testing.', 'nexlifydesk'); ?></p>
                </td>
            </tr>
            <tr>
                <th><label for="aws_region">AWS Region</label></th>
                <td>
                    <select name="nexlifydesk_imap_settings[aws_region]" id="aws_region" <?php echo !$is_ssl_enabled ? 'disabled' : ''; ?>>
                        <option value="us-east-1" <?php selected($imap_settings['aws_region'] ?? '', 'us-east-1'); ?>>US East (N. Virginia)</option>
                        <option value="us-west-2" <?php selected($imap_settings['aws_region'] ?? '', 'us-west-2'); ?>>US West (Oregon)</option>
                        <option value="eu-west-1" <?php selected($imap_settings['aws_region'] ?? '', 'eu-west-1'); ?>>Europe (Ireland)</option>
                        <option value="eu-central-1" <?php selected($imap_settings['aws_region'] ?? '', 'eu-central-1'); ?>>Europe (Frankfurt)</option>
                        <option value="ap-southeast-2" <?php selected($imap_settings['aws_region'] ?? '', 'ap-southeast-2'); ?>>Asia Pacific (Sydney)</option>
                    </select>
                    <p class="description"><?php esc_html_e('Select the AWS region where your WorkMail organization is located.', 'nexlifydesk'); ?></p>
                </td>
            </tr>
            <tr>
                <th><label for="aws_organization_id">Organization ID</label></th>
                <td>
                    <input type="text" name="nexlifydesk_imap_settings[aws_organization_id]" id="aws_organization_id" value="<?php echo esc_attr($imap_settings['aws_organization_id'] ?? ''); ?>" class="regular-text" <?php echo !$is_ssl_enabled ? 'disabled' : ''; ?>>
                    <p class="description"><?php esc_html_e('Your AWS WorkMail organization ID (e.g., m-abcdefghijklmnop).', 'nexlifydesk'); ?></p>
                </td>
            </tr>
            <tr>
                <th><label for="aws_email">Email Address</label></th>
                <td>
                    <input type="email" name="nexlifydesk_imap_settings[aws_email]" id="aws_email" value="<?php echo esc_attr($imap_settings['aws_email'] ?? ''); ?>" class="regular-text" <?php echo !$is_ssl_enabled ? 'disabled' : ''; ?>>
                    <p class="description"><?php esc_html_e('The WorkMail email address to monitor for incoming tickets.', 'nexlifydesk'); ?></p>
                </td>
            </tr>
            <tr>
                <th><label for="aws_password">Email Password</label></th>
                <td>
                    <?php if (!empty($imap_settings['aws_password'])): ?>
                        <input type="password" name="nexlifydesk_imap_settings[aws_password]" id="aws_password" value="••••••••••••••••" disabled style="background-color: #f7f7f7; border: 1px solid #ddd; cursor: not-allowed;" class="regular-text">
                        <input type="hidden" name="nexlifydesk_imap_settings[aws_password_preserved]" value="1" id="aws-password-preserved-flag">
                        <button type="button" id="edit-aws-password" class="button" style="margin-left: 5px;" <?php echo !$is_ssl_enabled ? 'disabled' : ''; ?>>Edit Password</button>
                        <p class="description">Password is saved and encrypted. Click "Edit Password" to change it.</p>
                    <?php else: ?>
                        <input type="password" name="nexlifydesk_imap_settings[aws_password]" id="aws_password" value="" placeholder="Enter email password" class="regular-text" <?php echo !$is_ssl_enabled ? 'disabled' : ''; ?>>
                        <p class="description">The password for the WorkMail email account.</p>
                    <?php endif; ?>
                </td>
            </tr>
            <tr>
                <th><label for="aws_access_key_id">AWS Access Key ID</label></th>
                <td>
                    <input type="text" name="nexlifydesk_imap_settings[aws_access_key_id]" id="aws_access_key_id" value="<?php echo esc_attr($imap_settings['aws_access_key_id'] ?? ''); ?>" class="regular-text" <?php echo !$is_ssl_enabled ? 'disabled' : ''; ?>>
                    <p class="description"><?php esc_html_e('AWS Access Key ID for SES authentication (optional for basic IMAP).', 'nexlifydesk'); ?></p>
                </td>
            </tr>
            <tr>
                <th><label for="aws_secret_access_key">AWS Secret Access Key</label></th>
                <td>
                    <?php if (!empty($imap_settings['aws_secret_access_key'])): ?>
                        <input type="password" name="nexlifydesk_imap_settings[aws_secret_access_key]" id="aws_secret_access_key" value="••••••••••••••••" disabled style="background-color: #f7f7f7; border: 1px solid #ddd; cursor: not-allowed;" class="regular-text">
                        <input type="hidden" name="nexlifydesk_imap_settings[aws_secret_access_key_preserved]" value="1" id="aws-secret-key-preserved-flag">
                        <button type="button" id="edit-aws-secret-key" class="button" style="margin-left: 5px;" <?php echo !$is_ssl_enabled ? 'disabled' : ''; ?>>Edit Secret Key</button>
                        <p class="description">Secret Access Key is saved and encrypted. Click "Edit Secret Key" to change it.</p>
                    <?php else: ?>
                        <input type="password" name="nexlifydesk_imap_settings[aws_secret_access_key]" id="aws_secret_access_key" value="" placeholder="Enter secret access key" class="regular-text" <?php echo !$is_ssl_enabled ? 'disabled' : ''; ?>>
                        <p class="description">AWS Secret Access Key for SES authentication (optional for basic IMAP).</p>
                    <?php endif; ?>
                </td>
            </tr>
            <tbody id="aws-imap-settings" style="display: <?php echo ($imap_settings['aws_integration_type'] ?? 'imap') === 'imap' ? 'table-row-group' : 'none'; ?>;">
                <tr>
                    <th>Connection Test</th>
                    <td>
                        <button type="button" id="test-aws-connection" class="button" <?php echo !$is_ssl_enabled ? 'disabled' : ''; ?>>Test AWS Connection</button>
                        <button type="button" id="test-aws-fetch-emails" class="button button-secondary" style="margin-left: 10px;" <?php echo !$is_ssl_enabled ? 'disabled' : ''; ?>>Test Email Fetch</button>
                        <button type="button" id="aws-diagnostics" class="button button-secondary" style="margin-left: 10px;">System Diagnostics</button>
                        <div id="aws-connection-result" style="margin-top: 10px;"></div>
                        <div id="aws-fetch-result" style="margin-top: 10px;"></div>
                        <div id="aws-diagnostics-result" style="margin-top: 10px;"></div>
                        <p class="description"><?php esc_html_e('Test the connection to AWS WorkMail, manually fetch emails for testing, or run system diagnostics.', 'nexlifydesk'); ?></p>
                    </td>
                </tr>
            </tbody>
            
            <tbody id="aws-lambda-settings" style="display: <?php echo ($imap_settings['aws_integration_type'] ?? '') === 'lambda' ? 'table-row-group' : 'none'; ?>;">
                <tr>
                    <th><label for="lambda_webhook_secret">Webhook Secret</label></th>
                    <td>
                        <?php 
                        $webhook_secret = $imap_settings['lambda_webhook_secret'] ?? '';
                        if (empty($webhook_secret)) {
                            $webhook_secret = wp_generate_password(32, false);
                        }
                        ?>
                        <input type="text" name="nexlifydesk_imap_settings[lambda_webhook_secret]" id="lambda_webhook_secret" value="<?php echo esc_attr($webhook_secret); ?>" class="regular-text" readonly>
                        <button type="button" id="regenerate-webhook-secret" class="button" style="margin-left: 5px;">Regenerate</button>
                        <p class="description"><?php esc_html_e('Secret key for securing webhook communications between Lambda and WordPress.', 'nexlifydesk'); ?></p>
                    </td>
                </tr>
                <tr>
                    <th>Webhook URL</th>
                    <td>
                        <input type="text" value="<?php echo esc_attr(add_query_arg('nexlifydesk_lambda_webhook', '1', home_url('/'))); ?>" class="regular-text" readonly>
                        <button type="button" id="copy-webhook-url" class="button" style="margin-left: 5px;">Copy URL</button>
                        <p class="description"><?php esc_html_e('Use this URL in your Lambda function as WORDPRESS_WEBHOOK_URL environment variable.', 'nexlifydesk'); ?></p>
                    </td>
                </tr>
                <tr>
                    <th>Setup Guide</th>
                    <td>
                        <a href="<?php echo esc_url(NEXLIFYDESK_PLUGIN_URL . 'email-source/providers/aws-ses/setup-guide.md'); ?>" target="_blank" class="button">View Setup Guide</a>
                        <button type="button" id="test-lambda-webhook" class="button button-secondary" style="margin-left: 10px;">Test Webhook</button>
                        <div id="lambda-webhook-result" style="margin-top: 10px;"></div>
                        <p class="description"><?php esc_html_e('Follow the setup guide to configure AWS SES and Lambda integration.', 'nexlifydesk'); ?></p>
                    </td>
                </tr>
            </tbody>
            <?php 
            
            if (!empty($imap_settings['aws_organization_id']) || !empty($imap_settings['aws_email']) || !empty($imap_settings['aws_password']) || !empty($imap_settings['aws_access_key_id']) || !empty($imap_settings['aws_secret_access_key'])):
            ?>
            <tr>
                <th>Clear Credentials</th>
                <td>
                    <a href="<?php echo esc_url(wp_nonce_url(admin_url('admin-post.php?action=nexlifydesk_deauth_aws'), 'nexlifydesk_deauth_aws')); ?>" class="button button-secondary" onclick="return confirm('Are you sure you want to clear AWS WorkMail credentials? This will remove all stored AWS settings.');">Clear AWS Credentials</a>
                    <p class="description"><?php esc_html_e('Remove all stored AWS WorkMail credentials and settings from the database.', 'nexlifydesk'); ?></p>
                </td>
            </tr>
            <?php endif; ?>
        </tbody>

        <tbody id="custom-settings" class="provider-settings" style="display: <?php echo $provider === 'custom' ? 'table-row-group' : 'none'; ?>;">
             <tr>
                 <th><label for="protocol">Protocol</label></th>
                 <td>
                     <select name="nexlifydesk_imap_settings[protocol]" id="protocol">
                         <option value="imap" <?php selected($imap_settings['protocol'] ?? 'imap', 'imap'); ?>>IMAP</option>
                         <option value="pop3" <?php selected($imap_settings['protocol'] ?? '', 'pop3'); ?>>POP3</option>
                     </select>
                 </td>
             </tr>
             <tr>
                 <th><label for="host">IMAP/POP3 Host</label></th>
                 <td><input type="text" name="nexlifydesk_imap_settings[host]" id="host" value="<?php echo esc_attr($imap_settings['host']); ?>" class="regular-text"></td>
             </tr>
             <tr>
                 <th><label for="port">Port</label></th>
                 <td><input type="number" name="nexlifydesk_imap_settings[port]" id="port" value="<?php echo esc_attr($imap_settings['port']); ?>" class="small-text"></td>
             </tr>
             <tr>
                 <th><label for="encryption">Encryption</label></th>
                 <td>
                     <select name="nexlifydesk_imap_settings[encryption]" id="encryption">
                         <option value="ssl" <?php selected($imap_settings['encryption'], 'ssl'); ?>>SSL</option>
                         <option value="tls" <?php selected($imap_settings['encryption'], 'tls'); ?>>TLS</option>
                         <option value="" <?php selected($imap_settings['encryption'], ''); ?>>None</option>
                     </select>
                 </td>
             </tr>
             <tr>
                 <th><label for="username">Username</label></th>
                 <td><input type="text" name="nexlifydesk_imap_settings[username]" id="username" value="<?php echo esc_attr($imap_settings['username']); ?>" autocomplete="off" class="regular-text"></td>
             </tr>
             <tr>
                 <th><label for="password">Password</label></th>
                 <td>
                     <?php if (!empty($imap_settings['password'])): ?>
                         <input type="password" name="nexlifydesk_imap_settings[password]" id="password" value="••••••••••••••••" disabled style="background-color: #f7f7f7; border: 1px solid #ddd; cursor: not-allowed;" autocomplete="off" class="regular-text">
                         <input type="hidden" name="nexlifydesk_imap_settings[password_preserved]" value="1" id="password-preserved-flag">
                         <button type="button" id="edit-custom-password" class="button" style="margin-left: 5px;">Edit Password</button>
                         <p class="description">Password is saved and encrypted. Click "Edit Password" to change it.</p>
                     <?php else: ?>
                         <input type="password" name="nexlifydesk_imap_settings[password]" id="password" value="" placeholder="Enter password" autocomplete="off" class="regular-text">
                         <p class="description">Enter your email account password.</p>
                     <?php endif; ?>
                 </td>
             </tr>
             <tr>
                 <th>Connection Test</th>
                 <td>
                     <button type="button" id="test-custom-connection" class="button">Test Custom Connection</button>
                     <button type="button" id="test-custom-fetch-emails" class="button button-secondary" style="margin-left: 10px;">Test Email Fetch</button>
                     <div id="custom-connection-result" style="margin-top: 10px;"></div>
                     <div id="custom-fetch-result" style="margin-top: 10px;"></div>
                     <p class="description"><?php esc_html_e('Test the connection to your custom IMAP/POP3 server and manually fetch emails for testing.', 'nexlifydesk'); ?></p>
                 </td>
             </tr>
             <?php 
             
             if (!empty($imap_settings['host']) || !empty($imap_settings['username']) || !empty($imap_settings['password'])):
             ?>
             <tr>
                 <th>Clear Credentials</th>
                 <td>
                     <a href="<?php echo esc_url(wp_nonce_url(admin_url('admin-post.php?action=nexlifydesk_deauth_custom'), 'nexlifydesk_deauth_custom')); ?>" class="button button-secondary" onclick="return confirm('Are you sure you want to clear custom IMAP/POP3 credentials? This will remove all stored custom email settings.');">Clear Custom Credentials</a>
                     <p class="description"><?php esc_html_e('Remove all stored custom IMAP/POP3 credentials and settings from the database.', 'nexlifydesk'); ?></p>
                 </td>
             </tr>
             <?php endif; ?>
        </tbody>
    </table>

    <div class="nexlifydesk-encryption-security">
        <?php nexlifydesk_show_encryption_key_instructions(); ?>
    </div>

    <div class="nexlifydesk-spam-protection">
        <h3><?php esc_html_e('Email Filtering & Spam Protection', 'nexlifydesk'); ?></h3>
        <table class="form-table">
        <tr>
            <th><label for="block_admin_emails"><?php esc_html_e('Block Admin Emails', 'nexlifydesk'); ?></label></th>
            <td>
                <input type="checkbox" name="nexlifydesk_imap_settings[block_admin_emails]" id="block_admin_emails" value="1" <?php checked($imap_settings['block_admin_emails'] ?? 0, 1); ?>>
                <p class="description"><?php esc_html_e('Block emails from the admin email address to prevent notification emails from creating tickets.', 'nexlifydesk'); ?></p>
            </td>
        </tr>
        <tr>
            <th><label for="block_notification_subjects"><?php esc_html_e('Block Notification Subjects', 'nexlifydesk'); ?></label></th>
            <td>
                <input type="checkbox" name="nexlifydesk_imap_settings[block_notification_subjects]" id="block_notification_subjects" value="1" <?php checked($imap_settings['block_notification_subjects'] ?? 0, 1); ?>>
                <p class="description"><?php esc_html_e('Block emails with subjects containing [Admin] or [Agent] prefixes.', 'nexlifydesk'); ?></p>
            </td>
        </tr>
        <tr>
            <th><label for="block_marketing_emails"><?php esc_html_e('Block Marketing Emails', 'nexlifydesk'); ?></label></th>
            <td>
                <input type="checkbox" name="nexlifydesk_imap_settings[block_marketing_emails]" id="block_marketing_emails" value="1" <?php checked($imap_settings['block_marketing_emails'] ?? 1, 1); ?>>
                <p class="description"><?php esc_html_e('Automatically detect and block marketing/promotional emails based on content analysis.', 'nexlifydesk'); ?></p>
            </td>
        </tr>
        <tr>
            <th><label for="blocked_emails"><?php esc_html_e('Blocked Email Addresses', 'nexlifydesk'); ?></label></th>
            <td>
                <textarea name="nexlifydesk_imap_settings[blocked_emails]" id="blocked_emails" rows="5" class="large-text"><?php echo esc_textarea($imap_settings['blocked_emails'] ?? ''); ?></textarea>
                <p class="description"><?php esc_html_e('Enter email addresses to block, one per line. Emails from these addresses will be ignored.', 'nexlifydesk'); ?></p>
            </td>
        </tr>
        <tr>
            <th><label for="blocked_domains"><?php esc_html_e('Blocked Domains', 'nexlifydesk'); ?></label></th>
            <td>
                <textarea name="nexlifydesk_imap_settings[blocked_domains]" id="blocked_domains" rows="3" class="large-text"><?php echo esc_textarea($imap_settings['blocked_domains'] ?? ''); ?></textarea>
                <p class="description"><?php esc_html_e('Enter domains to block, one per line (e.g., spam-domain.com). Emails from these domains will be ignored.', 'nexlifydesk'); ?></p>
            </td>
        </tr>
        <tr>
            <th><label for="spam_url_filtering"><?php esc_html_e('Enable URL Filtering', 'nexlifydesk'); ?></label></th>
            <td>
                <input type="checkbox" name="nexlifydesk_imap_settings[spam_url_filtering]" id="spam_url_filtering" value="1" <?php checked($imap_settings['spam_url_filtering'] ?? 0, 1); ?>>
                <p class="description"><?php esc_html_e('Block emails containing suspicious URLs or too many links (potential spam).', 'nexlifydesk'); ?></p>
            </td>
        </tr>
        <tr>
            <th><label for="max_links_per_email"><?php esc_html_e('Max Links Per Email', 'nexlifydesk'); ?></label></th>
            <td>
                <input type="number" name="nexlifydesk_imap_settings[max_links_per_email]" id="max_links_per_email" value="<?php echo esc_attr($imap_settings['max_links_per_email'] ?? 3); ?>" min="0" max="20" class="small-text">
                <p class="description"><?php esc_html_e('Maximum number of links allowed in an email. Emails with more links will be blocked as potential spam.', 'nexlifydesk'); ?></p>
            </td>
        </tr>
        <tr>
            <th><label for="blocked_keywords"><?php esc_html_e('Spam Keywords', 'nexlifydesk'); ?></label></th>
            <td>
                <textarea name="nexlifydesk_imap_settings[blocked_keywords]" id="blocked_keywords" rows="3" class="large-text"><?php echo esc_textarea($imap_settings['blocked_keywords'] ?? ''); ?></textarea>
                <p class="description"><?php esc_html_e('Enter spam keywords to block, one per line. Emails containing these words will be ignored.', 'nexlifydesk'); ?></p>
            </td>
        </tr>        </table>
    </div>

    <p class="submit">
        <?php submit_button(esc_html__('Save Settings', 'nexlifydesk'), 'primary', 'submit', false); ?>
        <button type="button" id="nexlifydesk-fetch-emails-now" class="button" style="margin-left:10px;">
            <?php esc_html_e('Fetch Emails Now', 'nexlifydesk'); ?>
        </button>
        <a href="<?php echo esc_url(wp_nonce_url(admin_url('admin-post.php?action=nexlifydesk_deauth_all'), 'nexlifydesk_deauth_all')); ?>" class="button button-secondary" style="margin-left:10px;" onclick="return confirm('Are you sure you want to clear ALL email provider credentials? This will remove all stored authentication data for Google, AWS, and Custom IMAP/POP3 providers.');">
            <?php esc_html_e('Clear All Credentials', 'nexlifydesk'); ?>
        </a>
        <span id="nexlifydesk-fetch-emails-status" style="margin-left:10px;"></span>
    </p>
</form>