<?php
namespace NexButton\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Icons_Manager;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

class NexButton_Widget extends Widget_Base {

    public function get_name() {
        return 'nex-button';
    }

    public function get_title() {
        return __( 'Creative Button', 'nex-button' );
    }

    public function get_icon() {
        return 'eicon-button';
    }

    public function get_categories() {
        return [ 'nexbutton-category' ]; // Custom category defined in main plugin file
    }

    protected function register_controls() {

        // Content Tab Start
        $this->start_controls_section(
            'section_title',
            [
                'label' => esc_html__( 'Button', 'nex-button' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
    
        // Button style multiple
        $this->add_control(
            'button_style',
            [
                'label' => __( 'Style', 'nex-button' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'style-1' => __( 'Style 1', 'nex-button' ),
                    'style-2' => __( 'Style 2', 'nex-button' ),
                    'style-3' => __( 'Style 3', 'nex-button' ),
                    'style-4' => __( 'Style 4', 'nex-button' ),
                ],
                'default' => 'style-1',
            ]
        );
    
        // Switcher for text
        $this->add_control(
            'button_text_switcher',
            [
                'label' => __( 'Show Text', 'nex-button' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
                'condition' => [
                    'button_style' => 'style-1',
                ],
            ]
        );
    
        // Switcher for icon
        $this->add_control(
            'button_icon_switcher',
            [
                'label' => __( 'Show Icon', 'nex-button' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
    
        // Heading for content
        $this->add_control(
            'heading_content',
            [
                'label' => __( 'Content', 'nex-button' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
    
        // Text
        $this->add_control(
            'button_text',
            [
                'label' => __( 'Text', 'nex-button' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Explore More',
                'placeholder' => 'Explore More',
                'condition' => [
                    'button_text_switcher' => 'yes',
                ],
            ]
        );
    
        // Button link
        $this->add_control(
            'button_link',
            [
                'label' => __( 'Link', 'nex-button' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => '#',
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                ],
            ]
        );
    
        // Icon
        $this->add_control(
            'button_icon',
            [
                'label' => __( 'Icon', 'nex-button' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-arrow-right',
                    'library' => 'solid',
                ],
                'condition' => [
                    'button_icon_switcher' => 'yes',
                ],
            ]
        );
    
        // Alignment
        $this->add_responsive_control(
            'button_align',
            [
                'label' => __( 'Alignment', 'nex-button' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', 'nex-button' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'nex-button' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'nex-button' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .cb-nex-button-wrapper' => 'text-align: {{VALUE}};',
                ],
                'default' => 'left',
            ]
        );
    
        $this->end_controls_section();
        // Content Tab End
    
        // Style Tab Start
        $this->start_controls_section(
            'section_title_style',
            [
                'label' => esc_html__( 'Button', 'nex-button' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
    
        // Start tabs
        $this->start_controls_tabs( 'button_style_tabs' );
    
        // Normal state
        $this->start_controls_tab(
            'button_style_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'nex-button' ),
            ]
        );
    
        $this->add_control(
            'button_text_color',
            [
                'label' => esc_html__( 'Color', 'nex-button' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cb-nex-button' => 'color: {{VALUE}};',
                ],
            ]
        );
    
        $this->add_control(
            'button_background_color',
            [
                'label' => esc_html__( 'Background Color', 'nex-button' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cb-nex-button' => 'background-color: {{VALUE}};',
                ],
            ]
        );
    
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'label' => esc_html__( 'Typography', 'nex-button' ),
                'selector' => '{{WRAPPER}} .cb-nex-button',
            ]
        );
    
        $this->add_responsive_control(
            'button_padding',
            [
                'label' => __( 'Padding', 'nex-button' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .cb-nex-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );
    
        $this->add_responsive_control(
            'button_margin',
            [
                'label' => __( 'Margin', 'nex-button' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .cb-nex-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
    
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'selector' => '{{WRAPPER}} .cb-nex-button',
                'border' => true,
                'separator' => 'before',
            ]
        );
    
        $this->add_responsive_control(
            'button_border_radius',
            [
                'label' => __( 'Border Radius', 'nex-button' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .cb-nex-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
    
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_box_shadow',
                'selector' => '{{WRAPPER}} .cb-nex-button',
            ]
        );
    
        $this->end_controls_tab();
    
        // Hover state
        $this->start_controls_tab(
            'button_style_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'nex-button' ),
            ]
        );
    
        $this->add_control(
            'button_hover_color',
            [
                'label' => esc_html__( 'Color', 'nex-button' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cb-nex-button:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
    
        $this->add_control(
            'button_hover_background_color',
            [
                'label' => esc_html__( 'Background Color', 'nex-button' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cb-nex-button:hover' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'button_style!' => 'style-4',
                ],
             ]
        );

        $this->add_control(
            'button_hover_background_color_style-4',
            [
                'label' => esc_html__( 'Background Color', 'nex-button' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cb-nex-button-wrapper.style-4 .cb-nex-button:after' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'button_style' => 'style-4',
                ],
            ]
        );
    
        $this->add_control(
            'button_hover_border_color',
            [
                'label' => esc_html__( 'Border Color', 'nex-button' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cb-nex-button:hover' => 'border-color: {{VALUE}};',
                ],
                'condition' => [
                    'button_border_border!' => '',
                ],
            ]
        );
    
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_hover_box_shadow',
                'selector' => '{{WRAPPER}} .cb-nex-button:hover',
            ]
        );
    
        $this->end_controls_tab();
        $this->end_controls_tabs();

        //star icon
        $this->add_control(
            'heading_icon',
            [
                'label' => __( 'Star', 'nex-button' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'star_color',
            [
                'label' => esc_html__( 'Color', 'nex-button' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cb-star-icon' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    
        // Icon Style Section
        $this->start_controls_section(
            'section_title_icon_style', 
            [
                'label' => esc_html__( 'Icon', 'nex-button' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
    
        // normal and hover tab start
        $this->start_controls_tabs( 'button_icon_style_tabs' );

                // normal state
                $this->start_controls_tab(
                    'button_icon_style_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'nex-button' ),
                    ]
                );

                // Icon size
                $this->add_responsive_control(
                    'button_icon_size',
                    [
                        'label' => __( 'Size', 'nex-button' ),
                        'type' => \Elementor\Controls_Manager::SLIDER,
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .cb-nex-button .button-icon svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
        
                // icon color
                $this->add_control(
                    'button_icon_color',
                    [
                        'label' => __( 'Color', 'nex-button' ),
                        'type' => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .cb-nex-button .button-icon svg' => 'fill: {{VALUE}};',
                        ],
                        'separator' => 'before',
                    ]
                );
        
                // background color
                $this->add_control(
                    'button_icon_background_color',
                    [
                        'label' => __( 'Background Color', 'nex-button' ),
                        'type' => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .cb-nex-button .button-icon' => 'background-color: {{VALUE}};',
                        ],
                    ]
                );
        
                // padding              
                $this->add_responsive_control(
                    'button_icon_padding',
                    [
                        'label' => __( 'Padding', 'nex-button' ),
                        'type' => \Elementor\Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .cb-nex-button .button-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'condition' => [
                            'button_style' => 'style-1',
                        ],
                        'separator' => 'before',
                        
                    ]
                );


                // icon background size
                $this->add_responsive_control(
                    'button_icon_background_size',
                    [
                        'label' => __( 'Background Size', 'nex-button' ),
                        'type' => \Elementor\Controls_Manager::SLIDER,
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .cb-nex-button .button-icon' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                        ],
                        'condition' => [
                            'button_style' => 'style-2',
                        ],
                        'separator' => 'before',
                    ]
                );

        
                // margin
                $this->add_responsive_control(
                    'button_icon_margin',
                    [
                        'label' => __( 'Margin', 'nex-button' ),
                        'type' => \Elementor\Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .cb-nex-button .button-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                    ]
                );

                // border
                $this->add_group_control(
                    \Elementor\Group_Control_Border::get_type(),
                    [
                        'name' => 'button_icon_border',
                        'selector' => '{{WRAPPER}} .cb-nex-button .button-icon',
                        'border' => true,
                        'separator' => 'before',
                    ]
                );
                // border radius
                $this->add_responsive_control(
                    'button_icon_border_radius',
                    [
                        'label' => __( 'Border Radius', 'nex-button' ),
                        'type' => \Elementor\Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .cb-nex-button .button-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                    ]
                );
                
        $this->end_controls_tab();

        // hover state
        $this->start_controls_tab(
            'button_icon_style_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'nex-button' ),
            ]
        );

        // icon color
        $this->add_control(
            'button_icon_hover_color',
            [
                'label' => __( 'Color', 'nex-button' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cb-nex-button:hover .button-icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        // background color
        $this->add_control(
            'button_icon_hover_background_color',
            [
                'label' => __( 'Background Color', 'nex-button' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cb-nex-button:hover .button-icon' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_icon_hover_border_color',
            [
                'label' => esc_html__( 'Border Color', 'nex-button' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cb-nex-button:hover .button-icon' => 'border-color: {{VALUE}};',
                ],
                'condition' => [
                    'button_icon_border_border!' => '',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }
    
    protected function render() {
        $settings = $this->get_settings_for_display();
        $target = $settings['button_link']['is_external'] ? ' target="_blank"' : '';
        $nofollow = $settings['button_link']['nofollow'] ? ' rel="nofollow"' : '';
        $url = esc_url($settings['button_link']['url']);
        $text = esc_html($settings['button_text']);
        $button_align = esc_attr($settings['button_align'] ?? 'left');

        echo "<div class='cb-nex-button-wrapper " . esc_attr($settings['button_style']) . " " . esc_attr($button_align) . "'>";
        echo "<a class='cb-nex-button' href='" . esc_url($url) . "'" . esc_attr($target) . esc_attr($nofollow) . ">";

        if (!empty($settings['button_text_switcher']) && 'yes' === $settings['button_text_switcher'] && 'style-1' === $settings['button_style']) {
            echo "<span class='button-text'>" . esc_html($text) . "</span>";
        }

        if (!empty($settings['button_style']) && ('style-2' === $settings['button_style'] || 'style-4' === $settings['button_style'])) {
            echo "<span class='button-text'>" . esc_html($text) . "</span>";
        }

        if (!empty($settings['button_style']) && 'style-3' === $settings['button_style']) {
            echo "<span class='button-text'>" . esc_html($text) . "</span>";
            echo "<div class='cb-star cb-star-1'>
                    <svg
                        xmlns='http://www.w3.org/2000/svg'
                        xml:space='preserve'
                        version='1.1'
                        style='shape-rendering:geometricPrecision; text-rendering:geometricPrecision; image-rendering:optimizeQuality; fill-rule:evenodd; clip-rule:evenodd'
                        viewBox='0 0 784.11 815.53'
                        xmlns:xlink='http://www.w3.org/1999/xlink'
                    >
                        <defs></defs>
                        <g id='Layer_x0020_1'>
                            <metadata id='CorelCorpID_0Corel-Layer'></metadata>
                            <path
                                class='cb-star-icon'
                                d='M392.05 0c-20.9,210.08 -184.06,378.41 -392.05,407.78 207.96,29.37 371.12,197.68 392.05,407.74 20.93,-210.06 184.09,-378.37 392.05,-407.74 -207.98,-29.38 -371.16,-197.69 -392.06,-407.78z'
                            ></path>
                        </g>
                    </svg>
                </div>";
        
            echo "<div class='cb-star cb-star-2'>
                    <svg
                        xmlns='http://www.w3.org/2000/svg'
                        xml:space='preserve'
                        version='1.1'
                        style='shape-rendering:geometricPrecision; text-rendering:geometricPrecision; image-rendering:optimizeQuality; fill-rule:evenodd; clip-rule:evenodd'
                        viewBox='0 0 784.11 815.53'
                        xmlns:xlink='http://www.w3.org/1999/xlink'
                    >
                        <defs></defs>
                        <g id='Layer_x0020_1'>
                            <metadata id='CorelCorpID_0Corel-Layer'></metadata>
                            <path
                                class='cb-star-icon'
                                d='M392.05 0c-20.9,210.08 -184.06,378.41 -392.05,407.78 207.96,29.37 371.12,197.68 392.05,407.74 20.93,-210.06 184.09,-378.37 392.05,-407.74 -207.98,-29.38 -371.16,-197.69 -392.06,-407.78z'
                            ></path>
                        </g>
                    </svg>
                </div>";
        
            echo "<div class='cb-star cb-star-3'>
                    <svg
                        xmlns='http://www.w3.org/2000/svg'
                        xml:space='preserve'
                        version='1.1'
                        style='shape-rendering:geometricPrecision; text-rendering:geometricPrecision; image-rendering:optimizeQuality; fill-rule:evenodd; clip-rule:evenodd'
                        viewBox='0 0 784.11 815.53'
                        xmlns:xlink='http://www.w3.org/1999/xlink'
                    >
                        <defs></defs>
                        <g id='Layer_x0020_1'>
                            <metadata id='CorelCorpID_0Corel-Layer'></metadata>
                            <path
                                class='cb-star-icon'
                                d='M392.05 0c-20.9,210.08 -184.06,378.41 -392.05,407.78 207.96,29.37 371.12,197.68 392.05,407.74 20.93,-210.06 184.09,-378.37 392.05,-407.74 -207.98,-29.38 -371.16,-197.69 -392.06,-407.78z'
                            ></path>
                        </g>
                    </svg>
                </div>";
        
            echo "<div class='cb-star cb-star-4'>
                    <svg
                        xmlns='http://www.w3.org/2000/svg'
                        xml:space='preserve'
                        version='1.1'
                        style='shape-rendering:geometricPrecision; text-rendering:geometricPrecision; image-rendering:optimizeQuality; fill-rule:evenodd; clip-rule:evenodd'
                        viewBox='0 0 784.11 815.53'
                        xmlns:xlink='http://www.w3.org/1999/xlink'
                    >
                        <defs></defs>
                        <g id='Layer_x0020_1'>
                            <metadata id='CorelCorpID_0Corel-Layer'></metadata>
                            <path
                                class='cb-star-icon'
                                d='M392.05 0c-20.9,210.08 -184.06,378.41 -392.05,407.78 207.96,29.37 371.12,197.68 392.05,407.74 20.93,-210.06 184.09,-378.37 392.05,-407.74 -207.98,-29.38 -371.16,-197.69 -392.06,-407.78z'
                            ></path>
                        </g>
                    </svg>
                </div>";
        
            echo "<div class='cb-star cb-star-5'>
                    <svg
                        xmlns='http://www.w3.org/2000/svg'
                        xml:space='preserve'
                        version='1.1'
                        style='shape-rendering:geometricPrecision; text-rendering:geometricPrecision; image-rendering:optimizeQuality; fill-rule:evenodd; clip-rule:evenodd'
                        viewBox='0 0 784.11 815.53'
                        xmlns:xlink='http://www.w3.org/1999/xlink'
                    >
                        <defs></defs>
                        <g id='Layer_x0020_1'>
                            <metadata id='CorelCorpID_0Corel-Layer'></metadata>
                            <path
                                class='cb-star-icon'
                                d='M392.05 0c-20.9,210.08 -184.06,378.41 -392.05,407.78 207.96,29.37 371.12,197.68 392.05,407.74 20.93,-210.06 184.09,-378.37 392.05,-407.74 -207.98,-29.38 -371.16,-197.69 -392.06,-407.78z'
                            ></path>
                        </g>
                    </svg>
                </div>";
        
            echo "<div class='cb-star cb-star-6'>
                    <svg
                        xmlns='http://www.w3.org/2000/svg'
                        xml:space='preserve'
                        version='1.1'
                        style='shape-rendering:geometricPrecision; text-rendering:geometricPrecision; image-rendering:optimizeQuality; fill-rule:evenodd; clip-rule:evenodd'
                        viewBox='0 0 784.11 815.53'
                        xmlns:xlink='http://www.w3.org/1999/xlink'
                    >
                        <defs></defs>
                        <g id='Layer_x0020_1'>
                            <metadata id='CorelCorpID_0Corel-Layer'></metadata>
                            <path
                                class='cb-star-icon'
                                d='M392.05 0c-20.9,210.08 -184.06,378.41 -392.05,407.78 207.96,29.37 371.12,197.68 392.05,407.74 20.93,-210.06 184.09,-378.37 392.05,-407.74 -207.98,-29.38 -371.16,-197.69 -392.06,-407.78z'
                            ></path>
                        </g>
                    </svg>
                </div>";
        }

        if (!empty($settings['button_icon_switcher']) && 'yes' === $settings['button_icon_switcher']) {
            echo "<span class='button-icon'>";
            Icons_Manager::render_icon($settings['button_icon'], ['aria-hidden' => 'true']);
            echo "</span>";
        }

        

        

        echo '</a>';
        echo '</div>';
    }
}

// Register the custom widget
add_action( 'widgets_init', function() {
    register_widget( 'NexButton\Widgets\NexButton_Widget' );
});










