# 本地化說明 (Localization Guide)

## 繁體中文本地化支援

本插件提供完整的繁體中文本地化支援。所有使用者介面、設定選項、錯誤訊息等都已提供繁體中文翻譯。

## 目前支援的語言

- **繁體中文 (Taiwan)** - `zh_TW` - 完整本地化 ✅

*註：插件預設即為繁體中文介面，無論在任何語言環境下都會顯示繁體中文內容。*

## 文件結構

```
languages/
├── newebpay-payment.pot          # 翻譯模板文件
├── newebpay-payment-zh_TW.po     # 繁體中文翻譯源文件
├── newebpay-payment-zh_TW.mo     # 繁體中文編譯文件
└── README.md                     # 本地化說明文件
```

## 技術資訊

- **文本域 (Text Domain)**: `newebpay-payment`
- **翻譯函數**: `__()`, `_e()`, `_x()`, `_n()`
- **載入方式**: `load_plugin_textdomain()`
- **編碼**: UTF-8
- **當前版本**: 完整繁體中文本地化支援

## 翻譯內容類別

本插件包含以下類別的可翻譯內容：

### 1. 基本設定
- 插件啟用/停用選項
- 測試模式設定
- 標題和描述

### 2. 支付方式
- 信用卡、ATM、超商等各種支付方式名稱
- 支付方式說明文字

### 3. 電子發票
- 發票設定選項
- 統一編號、載具等表單標籤
- 發票狀態訊息

### 4. 管理介面
- 後台設定頁面文字
- 幫助說明文字
- 錯誤和成功訊息

### 5. 前台顯示
- 結帳頁面文字
- 付款確認訊息
- 客戶通知內容

## 貢獻翻譯

如果您想為此插件貢獻翻譯，請：

1. Fork 此專案
2. 新增您的語言翻譯文件
3. 測試翻譯的正確性
4. 提交 Pull Request

## 技術資訊

- **文本域 (Text Domain)**: `newebpay-payment`
- **翻譯函數**: `__()`, `_e()`, `_x()`, `_n()`
- **載入方式**: `load_plugin_textdomain()`
- **編碼**: UTF-8
