<?php
/**
 * Plugin Name:       Neurogenesis Styler - Advanced CSS Controls for Native Blocks 
 * Plugin URI:        http://menthol-inc.com
 * Description:       The Missing Gutenberg Styler — Advanced design controls, custom variables, hover effects, and responsive styling without coding.

 * Version:           0.4.0 
 * Author:            mentholinc
 * Requires at least: 6.8
 * Requires PHP:      7.4
 * Text Domain:       neurogenesis-styler
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 *
 * @package           neurogenesis
 */

use Neurogenesis\Core\Blocks\FrontendDisplayCSS;
use Neurogenesis\Core\Blocks\FrontendSaveCSS;


// If this file is called directly, abort.
defined( 'WPINC' ) || die( 'yes, but actually no' );

define( 'NEUROGENESIS_PAGE_FILE', __FILE__ );
define( 'NEUROGENESIS_PATH', plugin_dir_path( __FILE__ ) );
define( 'NEUROGENESIS_URL', plugin_dir_url( __FILE__ ) );
define( 'NEUROGENESIS_ID', 'neurogenesis' );
define(
	'NEUROGENESIS_DISABLED_BLOCKS',
	array(
		'core/nextpage',
		'core/more',
	)
);
require_once NEUROGENESIS_PATH . 'neuro/Core/Autoloader.php';
require_once NEUROGENESIS_PATH . 'config/config.php';
require_once( NEUROGENESIS_PATH . 'neuro/Helpers/URL.php' );

neuro_require( 'neuro/Helpers/Array.php' );
neuro_require( 'neuro/Helpers/Registry.php' );
neuro_require( 'neuro/Helpers/FlashMessages.php' );
neuro_require( 'neuro/Helpers/Options.php' );
neuro_require( 'neuro/Helpers/Blocks.php' );
neuro_require( 'neuro/Helpers/Debug.php' );


// neuro_require( 'vendor/autoload.php' );

neuro_require( 'neuro/boot.php' );

require_once NEUROGENESIS_PATH . 'config/block-supports.php';
require_once NEUROGENESIS_PATH . 'config/block-bootstrap.php';





new FrontendSaveCSS();
new FrontendDisplayCSS();
