<?php
namespace Neurogenesis\Traits;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

trait IsWPOptionGroup {
	private $group_name = 'neuro_options';
	private $values     = array();

	// save only these fields
	private $only = array();

	public function save( $option_name, $option_value, $autoload = false ) {
		$option                 = get_option( $this->group_name, array() );
		$option[ $option_name ] = $option_value;

		return update_option( $this->group_name, $option, $autoload );
	}

	public function save_group( $options, $autoload = false ) {
		$old_options = $this->get_group();

		$options = array_merge( $old_options, $options );

		return update_option( $this->group_name, $options, $autoload );
	}

	public function get( $option_name, $default = null ) {
		$option = get_option( $this->group_name, array() );

		return isset( $option[ $option_name ] ) ? $option[ $option_name ] : $default;
	}

	public function delete( $option_name ) {
		$option = get_option( $this->group_name, array() );
		unset( $option[ $option_name ] );

		update_option( $this->group_name, $option );
	}

	public function get_group() {
		return get_option( $this->group_name, array() );
	}

	public function delete_group() {
		delete_option( $this->group_name );
	}

	public function get_fields() {
		$this->values = $this->get_group();
		$fields       = $this->fields();

		foreach ( $fields as $field_name => $field ) {
			if ( ! empty( $this->only ) && ! in_array( $field_name, $this->only ) ) {
				continue;
			}

			isset( $this->values[ $field_name ] ) ? $fields[ $field_name ]['value'] = $this->values[ $field_name ] : null;
		}

		return $fields;
	}

	public function only( $fields ) {
		$this->only = $fields;
	}

	public function get_group_name() {
		return $this->group_name;
	}
}
