<?php
namespace Neurogenesis\Traits;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

trait IsSingleton {
	private static $instance = null;

	private function __construct() {}
	private function __clone() {}
	public function __wakeup() {
		throw new \Exception( 'Cannot unserialize singleton' );
	}

	public static function getInstance(): self {
		if ( self::$instance === null ) {
			self::$instance = new static();
		}
		return self::$instance;
	}
}
