<?php
namespace Neurogenesis\Traits;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

trait IsPrompt {
	public function prompt( $prompt_text ) {
		//
	}

	public function prompt_template( $prompt, $variables = array() ) {

		return $this->parse_prompt( $prompt, $variables );
	}

	public function parse_prompt( $template, $variables ) {
		// Use preg_replace_callback to match {{var|default}} format
		return preg_replace_callback(
			'/{{\s*(\w+)\s*(?:\|\s*([^}]*)\s*)?}}/',
			function ( $matches ) use ( $variables ) {
				$var_name      = $matches[1]; // Extract the variable name from {{var}}
				$default_value = isset( $matches[2] ) ? $matches[2] : $var_name; // Extract the default value, if provided

				// Return the variable value if it exists, otherwise use the default
				return isset( $variables[ $var_name ] ) ? $variables[ $var_name ] : $default_value;
			},
			$template
		);
	}

	public static function get_section_variables( $prompt_section ) {
		$variables = array();

		switch ( $prompt_section ) {
			case 'generate_section':
				$variables = array(
					'section_name'        => 'Section Name',
					'section_description' => 'Section Description',
				);
				break;
			case 'generate_page':
				$variables = array(
					'page_name'        => 'Page Name',
					'page_description' => 'Page Description',
				);
				break;
		}

		return $variables;
	}
}
