<?php
namespace Neurogenesis\Traits;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

trait IsBlock {
	use HasStyles;

	protected static $attributes = array();
	protected static $content    = '';
	protected static $block;
	protected static $elements              = array();
	protected static $default_tag           = 'div';
	protected static $wrapper               = 'WRAPPER';
	protected static $wrapper_id            = 'WRAPPER';
	protected static $default_wrapper_id    = 'WRAPPER';
	protected static $block_name            = null;
	protected static $default_block_support = '__default__';
	protected static $block_settings        = array();
	// protected static $styles = [];

	public static function init( $attributes, $content, $block ) {
		self::$attributes = $attributes;
		self::$content    = $content;
		self::$block      = $block;

		self::elements();

		self::set_styles();

		self::init_block_name();

		return self::render( $content );
	}

	public static function generate_for_css( $attributes, $block ) {
		self::$attributes = $attributes;
		self::$block      = new \WP_Block( $block );

		self::elements();

		if ( isset( $attributes['ordered'] ) && $attributes['ordered'] === true ) {
			self::$default_tag = 'ol';
		}

		self::set_styles();
		self::init_block_name();

	}

	public static function getValueByPath( $array, $path, $default = null ) {
		$keys  = explode( '.', $path );
		$value = $array;
		foreach ( $keys as $key ) {
			if ( isset( $value[ $key ] ) ) {
				$value = $value[ $key ];
			} else {
				return $default;
			}
		}
		return $value;
	}

	public static function get_attribute( $path, $default = null ) {
		return self::getValueByPath( self::$attributes, $path, $default );
	}

	public static function get_prop( $path, $default = null ) {
		if ( ! isset( self::$attributes['neuro']['_props'] ) ) {
			return $default;
		}

		return self::getValueByPath( self::$attributes['neuro']['_props'], $path, $default );
	}

	public static function get_attributes() {
		return self::$attributes;
	}

	public static function get_content() {
		return self::$content;
	}

	public static function init_block_name() {
		if ( isset( self::$block->parsed_block['blockName'] ) ) {
			self::$block_name = explode( '/', self::$block->parsed_block['blockName'] );
		}
	}

	public static function get_block_name() {
		if ( ! self::$block_name ) {
			return '';
		}

		return end( self::$block_name );
	}

	public static function getParentPath( array $elements, string $key ): string {
		if ( ! isset( $elements[ $key ] ) ) {
			return '';
		}

		$parent = $elements[ $key ];

		if ( isset( $parent['className'] ) ) {
			return '.' . $parent['className'];
		}

		return '';
	}

	private static function add_tag_to_selector( $selector, $item ) {

		if ( isset( $item['tag'] ) && $item['tag'] !== '' ) {
			if ( strpos( $item['tag'], '<wrapper_tag>' ) !== false ) {
				$selector = str_replace( '<wrapper_tag>', self::$default_tag, $item['tag'] ) . trim( $selector );
			} else {
				$selector = $item['tag'] . trim( $selector );
			}
		}

		return $selector;
	}

	public static function generateCssPaths( array $elements ): array {
		$prefix = '.' . NEUROGENESIS_ID;

		$neuro_id     = self::get_neuro_id();
		$unique_class = '.neuro-block-style-' . $neuro_id;

		$wrapper_class_name = isset( $elements[ self::$wrapper_id ]['className'] ) && $elements[ self::$wrapper_id ]['className'] !== '' ? $elements[ self::$wrapper_id ]['className'] : '';
		$unique_class       = $unique_class . '' . $wrapper_class_name;

		$parent_path = isset(
			$elements[ self::$wrapper_id ]['parent']
		) ? $elements[ self::$wrapper_id ]['parent']
		: '';

		$wrapper_class_name = $prefix . ' ' . $parent_path . ' ' . self::add_tag_to_selector( $unique_class, $elements[ self::$wrapper_id ] ) . '';

		// Helper function to recursively get the parent's CSS path

		$updated_elements = array();

		foreach ( $elements as $key => $item ) {
			$css_path = '';

			if ( $key === self::$wrapper_id ) {
				// Wrapper path includes only the wrapper class
				$css_path = $wrapper_class_name;
			} elseif ( isset( $item['className'] ) && $item['className'] !== '' ) {
				// For items with className
				$css_path = $wrapper_class_name . ' ' . self::add_tag_to_selector( $item['className'], $item );
			} elseif ( isset( $item['selector'] ) && $item['selector'] !== '' ) {
				// For items with selector, resolve parent path
				if ( isset( $item['use_wrapper_class'] ) && $item['use_wrapper_class'] === true ) {
					$css_path = $wrapper_class_name . self::add_tag_to_selector( $item['selector'], $item );
				} else {
					$css_path = $wrapper_class_name . ' ' . $parent_path . ' ' . self::add_tag_to_selector( $item['selector'], $item );
				}
				// pseudo_element
				if ( isset( $item['pseudo_element'] ) && $item['pseudo_element'] !== '' ) {
					$css_path = $css_path . $item['pseudo_element'];
				}

				// $css_path = $wrapper_class_name . ' ' . $parent_path . ' ' . self::add_tag_to_selector( $item['selector'], $item );
				$css_path = preg_replace( '/\s+/', ' ', $css_path );
			}

			// Add the css_path property
			$updated_elements[ $key ] = array_merge( $item, array( 'css_path' => $css_path ) );
		}

		return $updated_elements;
	}

	private static function get_block_support_name() {
		if ( ! self::$block->block_type->name ) {
			return self::$default_block_support;
		}

		return self::$block->block_type->name;
	}

	private static function get_block_supports() {
		$supports = isset( self::$block->block_type->supports['neuro']['elements'] ) ? self::$block->block_type->supports['neuro']['elements'] : null;

		if ( $supports === null ) {
			$support_group = self::get_block_support_name();
			$supports      = isset( NEUROGENESIS_BLOCK_SUPPORTS[ $support_group ] )
				? NEUROGENESIS_BLOCK_SUPPORTS[ $support_group ]['elements'] : NEUROGENESIS_BLOCK_SUPPORTS[ self::$default_block_support ]['elements'];

			$supports = array_merge( $supports, self::get_custom_elements() );

		}

		return $supports;
	}

	public static function get_custom_elements() {
		$custom_elements = self::get_prop( 'customElements' );
		$elements        = array();

		if ( $custom_elements ) {
			foreach ( $custom_elements as $element ) {
				$new_element = array(
					'styles'    => 'WRAPPERS',
					'states'    => array( 'DEFAULT', 'HOVER' ),
					'selector'  => $element['selector'],
					'className' => '',
					'label'     => $element['name'],
				);				
				$elements[ $element['id'] ] = $new_element;
			}
		}
		return $elements;
	}

	public static function elements() {
		$supports = self::get_block_supports();		

		if ( $supports ) {
			self::set_wrapper();
			$supports = self::generateCssPaths( $supports );

			foreach ( $supports as $element => $options ) {
				// error_log( print_r( 'supports', true ) );
				// error_log( print_r( $options, true ) );
				self::$elements[ $element ] = $options;
			}
		}
	}

	public static function set_wrapper() {
		$supports         = self::get_block_supports();
		self::$wrapper_id = self::$default_wrapper_id;

		if ( $supports ) {
			foreach ( $supports as $element => $options ) {
				if ( isset( $options['is_wrapper'] ) && self::is_wrapper(
					$options['is_wrapper']
				) ) {
					self::$wrapper_id = $element;
				}
			}

			self::$wrapper = $supports[ self::$wrapper_id ];
		}
	}

	public static function is_wrapper( $is_wrapper ) {
		if ( is_array( $is_wrapper ) ) {
			return isset(
				self::$attributes[ $is_wrapper[0] ]
			) && self::$attributes[ $is_wrapper[0] ] === $is_wrapper[1];
		}

		return $is_wrapper === true;
	}

	public static function styledElement( $element, $closing_tag = false, $atts = array() ) {
		if ( $closing_tag ) {
			echo wp_kses_post( self::closing_element( $element ) );
			return;
		}

		echo wp_kses_post( self::opening_element( $element, $atts ) );
	}

	public static function opening_element( $element, $atts = array() ) {
		$attributes = '';

		if ( isset( self::$elements[ $element ] ) ) {
			if ( self::$wrapper === $element ) {
				$attributes = get_block_wrapper_attributes( array( 'class' => self::get_element_class_name( $element, $atts ) ) );
			} else {
				$attributes = 'class="' . self::get_element_class_name( $element, $atts ) . '"';
			}

			return '<' . self::get_element_tag( $element, $atts ) . ' ' . $attributes . '>';
		}
	}

	public static function generate_element_classname( $element ) {
		return 'neuro--' . self::get_block_name() . '__' . strtolower( $element );
	}

	public static function generate_css_path( $element ) {
		if ( isset( self::$elements[ $element ] ) ) {
			return self::$elements[ $element ];
		}
	}

	public static function generate_unique_class_ids( $element ) {
		$neuro_id = self::get_neuro_id();

		$wrapper_class = array( self::generate_element_classname( self::$wrapper ) );
		$unique_class  = 'neuro-block-style-' . $neuro_id;

		$element_options = isset( self::$elements[ $element ] ) ? self::$elements[ $element ] : array();

		if ( self::$wrapper !== $element ) {
			$unique_class = '';
		}

		if ( isset( $element_options['parent'] ) ) {
			$parent_class    = self::generate_unique_class_ids( $element_options['parent'] );
			$wrapper_class[] = $parent_class[0];
			// $unique_class = $parent_class[0].'-'.strtolower($element);
			$unique_class = isset( $element_options['selector'] ) ? $element_options['selector'] : $unique_class;
		}

		return array( $unique_class, $wrapper_class );
	}

	public static function generate_unique_class_ids_path( $element ) {
		$neuro_id      = self::get_neuro_id();
		$wrapper_class = array( 'neuro-block-style-' . $neuro_id . '-' . strtolower( self::$wrapper ) );

		$unique_class = 'neuro-block-style-' . $neuro_id . '-' . strtolower( $element );

		$element_options = isset( self::$elements[ $element ] ) ? self::$elements[ $element ] : array();

		if ( self::$wrapper === $element ) {
			$wrapper_class = array();
		}

		if ( isset( $element_options['parent'] ) ) {
			$parent_class    = self::generate_unique_class_ids( $element_options['parent'] );
			$wrapper_class[] = $parent_class[0];
			// $unique_class = $parent_class[0].'-'.strtolower($element);
			$unique_class = isset( $element_options['selector'] ) ? $element_options['selector'] : $unique_class;
		}

		return array( $unique_class, $wrapper_class );
	}

	public static function get_element_class_name( $element, $atts = array() ) {
		$base_class = isset( self::$elements[ $element ]['className'] ) ? self::$elements[ $element ]['className'] : 'neuro--' . self::get_block_name() . '__' . strtolower( $element );

		// error_log(print_r(self::$attributes, true));
		$neuro_id = self::get_neuro_id();

		$selector = NEUROGENESIS_ID;
		// $unique_class = 'neuro-block-style-'.$neuro_id.'-'.strtolower($element);
		$unique_class = self::generate_unique_class_ids( $element );

		$classnames = 'x';

		$base_class .= ' ' . $unique_class[0];

		if ( isset( $atts['className'] ) ) {
			return $base_class . ' ' . $atts['className'];
		}

		return $base_class;
	}

	public static function get_neuro_id() {
		return self::get_prop( 'neuroID' );
	}

	public static function closing_element( $element ) {
		if ( isset( self::$elements[ $element ] ) ) {
			return '</' . self::get_element_tag( $element ) . '>';
		}
	}

	public static function get_element_tag( $element, $atts = array() ) {
		if ( isset( $atts['tag'] ) ) {
			return $atts['tag'];
		}

		return isset( self::$elements[ $element ]['tag'] ) ? self::$elements[ $element ]['tag'] : self::$default_tag;
	}

	public static function renderHTMLHeading() {
		$heading_text    = self::get_attribute( 'headingText', false );
		$heading_level   = self::get_attribute( 'headingLevel', 'h2' );
		$heading_display = self::get_attribute( 'headingDisplay', true );

		if ( $heading_display ) {
			echo wp_kses_post( self::styledElement( 'HEADING', false, array( 'tag' => $heading_level ) ) );
			// echo '<'. $heading_level .'>'. $heading_text .'</'. $heading_level .'>';
			echo esc_html( $heading_text );
			echo wp_kses_post( self::styledElement( 'HEADING', true ) );
		}
	}
}
