<?php

namespace Neurogenesis\Traits;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

trait HasTemplate {
	//main template folder, used to separate admin and frontend in different folders
	public static $folder = 'assets/admin/views';

	// the main layout
	public static $__layout = '_layout';

	public static $__sections = array();

	/**
	 * template - load a HTML template
	 *
	 * @param  mixed $template
	 * @param  mixed $args
	 * @param  mixed $echo
	 * @return void
	 */
	public static function template( $template, $args = array(), $echo = true ) {
		// phpcs:ignore WordPress.PHP.DontExtract.extract_extract
		extract( $args );
		ob_start();
		require NEUROGENESIS_PATH . self::$folder . '/' . $template . '.php';
		$str = ob_get_clean();

		if (
			! $echo
		) {
			return $str;
		}

		echo wp_kses_post( $str );
	}

	public static function show404( $args = array(), $message = null ) {
		// self::template( '_not_found', array( 'message' => $message ) );
		$args['message'] = $message;

		$args['content'] = self::template( '_not_found', $args, false );

		self::layout( '_layout', $args );
		die();
	}

	public static function make_section( $template, $args = array() ) {
		self::$__sections[ $template ] = self::template( $template, $args, false );
	}

	public static function section( $template ) {
		if ( isset( self::$__sections[ $template ] ) ) {
			echo wp_kses_post( self::$__sections[ $template ] );
		}
	}

	public static function layout( $layout = false, $args = array() ) {
		if ( $layout ) {
			self::template( $layout, $args );
		} else {
			self::template( self::$__layout, $args );
		}
	}

	public static function set_folder( $folder ) {
		self::$folder = $folder;
	}
}
