<?php
namespace Neurogenesis\Traits;

use Neurogenesis\Traits\Blocks\BorderStyles;
use Neurogenesis\Traits\Blocks\TypographyStyles;
use Neurogenesis\Traits\Blocks\SpacingStyles;
use Neurogenesis\Traits\Blocks\TransitionStyles;
use Neurogenesis\Traits\Blocks\BackgroundStyles;
use Neurogenesis\Traits\Blocks\ListStyles;
use Neurogenesis\Traits\Blocks\BlockSizingStyles;
use Neurogenesis\Traits\Blocks\BlockDisplayStyles;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

trait HasStyles {
	use BorderStyles;
	use TypographyStyles;
	use SpacingStyles;
	use TransitionStyles;
	use BackgroundStyles;
	use ListStyles;
	use BlockSizingStyles;
	use BlockDisplayStyles;
	protected static $styles = array();
	public static function set_styles() {
		self::$styles = self::get_attribute( 'neuro._styles', array() );
	}

	public static function css_value( $css_name, $value ) {
		if ( is_array( $value ) ) {
			return self::css_value_with_unit( $value );
		}

		switch ( $css_name ) {
			// case 'boxShadow':
			// 	return self::box_shadow_style( $value );
			// 	break;
			case 'padding':
			case 'margin':
				return self::css_add_unit_to_value( $value );
				break;
			default:
				return $value;
		}
	}

	public static function css_add_unit_to_value( $value ) {
		if ( ! is_array( $value ) ) {
			if ( ! preg_match( '/px|em|rem|%|vh|vw|auto|inherit|none/', $value ) ) {
				$value .= 'px';
			}
		}

		return $value;
	}

	public static function css_property_name( $key ) {
		// camel case to kebab case
		return strtolower( preg_replace( '/(?<=\d)(?=[A-Za-z])|(?<=[A-Za-z])(?=\d)|(?<=[a-z])(?=[A-Z])/', '-', $key ) );
	}

	public static function parse_style( $key, $value ) {
		$css_values = array();
		if ( is_array( $value ) ) {
			$css_values = array_merge( $css_values, self::multiple_style( $key, $value ) );

		} else {
			$css_val = self::css_value( $key, $value );
			if ( $key !== 'randomKey' && $css_val ) {
				$css_values[] = self::css_property_name( $key ) . ':' . $css_val;
			}
		}

		return array_values( $css_values );
	}

	public static function multiple_style( $key, $value ) {
		$css_values = array();

		switch ( $key ) {
			case 'boxShadow':
				return array( self::box_shadow_style( $value ) );
			case 'border':
				return array( self::border_style( $value ) );
			case 'borderRadius':
				return array( self::border_radius_style( $value ) );
			case 'typography':
				return array( self::typography_style( $value ) );
			case 'padding':
			case 'margin':
				return array( self::spacing_styles( $key, $value ) );
			case 'transition':
				return array( self::transition_styles( $value ) );
			case 'background':
				return array( self::background_styles( $value ) );
			case 'blockSizing':
				return array( self::block_sizing_styles( $value ) );
			case 'blockDisplay':
				return array( self::block_display_styles( $value ) );
			case 'listStyle':
				return array( self::list_styles( $value ) );
		}

		if ( $key === '_states' ) {
			return array();
		}

		foreach ( $value as $sub_key => $sub_value ) {
			$css_values[] = $key . '-' . $sub_key . ':' . self::css_value( $key, $sub_value );
		}

		return array_values( $css_values );
	}



	public static function get_element_styles( $element, $media = 'desktop' ) {
		$styles = array();

		if ( isset( self::$styles[ $media ] ) && isset( self::$styles[ $media ][ $element ] ) ) {
			$element_styles = self::$styles[ $media ][ $element ];

			if ( isset( $element_styles['_states'] ) ) {
				$states = $element_styles['_states'];
				// unset(self::$styles[$element]['_states']);

				$styles = array_merge( $styles, self::parse_state_styles( $states ) );
			}

			foreach ( $element_styles as $key => $value ) {
				$styles = array_merge( $styles, self::parse_style( $key, $value ) );
			}
		}

		if ( ! empty( $styles ) ) {
			return $styles;
		}

		return false;
	}

	public static function parse_state_styles( $states ) {
		$styles = array();
		foreach ( $states as $state_key => $state_styles ) {
			$sub_styles = array();
			foreach ( $state_styles as $sub_key => $sub_value ) {
				$css = self::parse_style( $sub_key, $sub_value );
				if ( ! empty( $css ) ) {
					$sub_styles[] = $css[0];
				}
			}

			$styles['_states'][ $state_key ] = $sub_styles;
		}

		return $styles;
	}

	public static function css_value_with_unit( $value, $skip_unit = false ) {

		if ( is_array( $value ) ) {
			$css_unit  = array_key_exists( 'unit', $value ) ? $value['unit'] : 'px';
			$css_value = array_key_exists( 'value', $value ) ? $value['value'] : false;
			if ( strpos( $css_value, 'calc(' ) === 0 || strpos( $css_value, 'clamp(' ) === 0 ) {
				return $css_value;
			}

			if ( $css_value === 'none' || $css_value === 'auto' || $css_value === 'inherit' || strpos( $css_value, 'var(' ) === 0 ) {
				return $css_value;
			}

			if ( $css_value !== false && $css_value !== '' && ! $skip_unit ) {
				return $css_value . '' . $css_unit;
			}

			if ( $css_value !== false && $css_value !== '' && $skip_unit ) {
				return $css_value;
			}

			return false;
		}

		return self::css_add_unit_to_value( $value );
	}


	public static function box_shadow_style( $value ) {
		if ( is_array( $value ) ) {
			return self::box_shadow_style_with_unit( $value );
		}
	}

	public static function box_shadow_style_with_unit( $value ) {
		$horizontal_offset = array_key_exists( 'horizontalOffset', $value ) ? self::css_value_with_unit( $value['horizontalOffset'] ) : 0;
		$vertical_offset   = array_key_exists( 'verticalOffset', $value ) ? self::css_value_with_unit( $value['verticalOffset'] ) : 0;
		$blur_radius       = array_key_exists( 'blurRadius', $value ) ? self::css_value_with_unit( $value['blurRadius'] ) : 0;
		$spread            = array_key_exists( 'spread', $value ) ? self::css_value_with_unit( $value['spread'] ) : 0;
		$color             = array_key_exists( 'color', $value ) ? $value['color'] : '#000000';

		return 'box-shadow: ' . $horizontal_offset . ' ' . $vertical_offset . ' ' . $blur_radius . ' ' . $spread . ' ' . $color . ';';
	}

}
