<?php
namespace Neurogenesis\Traits;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

trait HasAction {
	/**
	 * Check action nonce
	 *
	 * @return boolean
	 */
	public function checkNonce( $action, $get = false ) {
		if ( $get ) {
			$nonce = sanitize_text_field( wp_unslash( $_GET['_wpnonce'] ?? '' ) );
			return ! empty( $nonce ) && wp_verify_nonce( $nonce, $action );
		} else {
			$nonce = sanitize_text_field( wp_unslash( $_POST['_wpnonce'] ?? '' ) );
			return ! empty( $nonce ) && wp_verify_nonce( $nonce, $action );
		}
	}

	/**
	 * Nonce invalid standard message
	 *
	 * @param  string $message
	 * @param  string $status
	 * @return void
	 */
	public function nonceInvalidMessage( string $message = null, $status = 'error' ) {
		if ( $message != null ) {
			neuro_flash_message_add( $message, $status );
		} else {
			neuro_flash_message_add( __( 'There was a problem with your request. Nonce verification failed.', 'neurogenesis-styler' ), 'error' );
		}
	}

	/**
	 * Redirect to an admin page
	 *
	 * @param  string $url
	 * @return void
	 */
	public function redirectToSettingsPage( string $url = null, $args = array() ) {
		if ( $url != null ) {
			wp_safe_redirect( neuro_generate_page_url( $url, $args ) );
		} else {
			// Verify nonce and validate referer before redirecting
			$nonce   = sanitize_text_field( wp_unslash( $_POST['_wpnonce'] ?? '' ) );
			$referer = esc_url_raw( wp_unslash( $_POST['_wp_http_referer'] ?? '' ) );

			if ( ! empty( $nonce ) && ! empty( $referer ) &&
				 wp_verify_nonce( $nonce, 'redirect_action' ) ) {
				wp_safe_redirect( $referer );
			} else {
				// Fallback to admin page if nonce verification fails
				wp_safe_redirect( admin_url() );
			}
		}
		exit;
	}
}
