<?php
namespace Neurogenesis\Traits\Blocks;
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
trait TypographyStyles {

	public static function typography_style( $value ) {
		$css_values = array();

		if ( empty( $value ) ) {
			return false;
		}

		foreach ( $value as $css_name => $css_value ) {
			$val = self::typography_rule( $css_name, $css_value );
			if ( self::is_empty_value( $val ) ) {
				continue;
			}

			$css_values[] = self::css_property_name( $css_name ) . ':' . $val;
		}

		return implode( ';', $css_values );
	}

	public static function is_empty_value( $value ) {
		return $value === false || $value === null || $value === '' || $value === '0';
	}

	public static function typography_rule( $css_name, $css_value ) {
		switch ( $css_name ) {
			case 'textTransform':
			case 'textDecoration':
			case 'fontStyle':
			case 'fontFamily':
			case 'textAlign':
			case 'color':
				return $css_value;
				break;
			case 'fontSize':
			case 'lineHeight':
			case 'letterSpacing':
				return self::css_value_with_unit( $css_value );
				break;
			case 'textShadow':
				return self::text_shadow_style( $css_value );
				break;
		}
	}

	public static function text_shadow_style( $value ) {
		if ( $value === 'none' ) {
			return 'none';
		}

		$x     = isset( $value[0] ) ? self::css_value_with_unit( $value[0] ) : 0;
		$y     = isset( $value[1] ) ? self::css_value_with_unit( $value[1] ) : 0;
		$blur  = isset( $value[2] ) ? self::css_value_with_unit( $value[2] ) : 0;
		$color = isset( $value[3] ) ? $value[3] : '#000000';

		return $x . ' ' . $y . ' ' . $blur . ' ' . $color;
	}
}
