<?php
namespace Neurogenesis\Traits\Blocks;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

trait TransitionStyles {
	private static $transition_property = 'all';

	public static function transition_styles( $value ) {
		if ( ! is_array( $value ) || empty( $value ) || $value['duration']['value'] === 0 ) {
			return false;
		}

		$duration = self::css_value_with_unit( $value['duration'] );
		$delay    = self::css_value_with_unit( $value['delay'] );
		$speed    = $value['speed'];

		return 'transition: ' . self::$transition_property . ' ' . $duration . ' ' . $speed . ' ' . $delay;
	}
}
