<?php
namespace Neurogenesis\Traits\Blocks;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

trait SpacingStyles {
	public static function spacing_styles( $key, $value ) {
		// remove empty values
		$value = array_filter(
			$value,
			function ( $val ) {
				return $val !== null && $val !== '' && $val !== false;
			}
		);

		if ( empty( $value ) ) {
			return false;
		}

		$styles = array();
		$values = array(
			'top'    => isset( $value['top'] ) && is_array( $value['top'] ) && isset( $value['top']['value'] ) && $value['top']['value'] !== '' ? $value['top'] : null,
			'right'  => isset( $value['right'] ) && is_array( $value['right'] ) && isset( $value['right']['value'] ) && $value['right']['value'] !== '' ? $value['right'] : null,
			'bottom' => isset( $value['bottom'] ) && is_array( $value['bottom'] ) && isset( $value['bottom']['value'] ) && $value['bottom']['value'] !== '' ? $value['bottom'] : null,
			'left'   => isset( $value['left'] ) && is_array( $value['left'] ) && isset( $value['left']['value'] ) && $value['left']['value'] !== '' ? $value['left'] : null,
		);

		if (
			$values['top'] !== null &&
			$values['right'] !== null &&
			$values['bottom'] !== null &&
			$values['left'] !== null &&
			$values['top']['value'] === $values['right']['value'] &&
			$values['top']['value'] === $values['bottom']['value'] &&
			$values['top']['value'] === $values['left']['value'] &&
			$values['top']['unit'] === $values['right']['unit'] &&
			$values['top']['unit'] === $values['bottom']['unit'] &&
			$values['top']['unit'] === $values['left']['unit']
		) {
			$styles[] = $key . ': ' . self::css_value_with_unit( $values['top'] );
		} else {

			if ( isset( $values['top'] ) && isset( $values['bottom'] )
			&& $values['top']['value'] === $values['bottom']['value'] && $values['left']['value'] === $values['right']['value'] && $values['top']['unit'] === $values['bottom']['unit'] && $values['left']['unit'] === $values['right']['unit'] ) {
				$styles[] = $key . ': ' . self::css_value_with_unit( $values['top'] ) . ' ' . self::css_value_with_unit( $values['left'] );

			} else {
				foreach ( $values as $label => $value ) {
					if ( isset( $value['value'] ) && $value['value'] !== null && $value['value'] !== '' ) {
						$styles[] = $key . '-' . $label . ': ' . self::css_value_with_unit( $value );
					}
				}
			}
		}

		$css = implode( ';', array_values( $styles ) );

		if ( empty( $css ) ) {
			return false;
		}

		return $css;
	}
}
