<?php

namespace Neurogenesis\Traits\Blocks;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

trait ListStyles {

	public static function list_styles( $value ) {
		$css_values = array();

		foreach ( $value as $sub_key => $sub_value ) {
			switch ( $sub_key ) {
				case 'listStyleType':
					if ( ! empty( $sub_value ) ) {
						$css_values[] = self::css_property_name( $sub_key ) . ':' . $sub_value;
					}
					break;
				case 'listStylePosition':
					if ( ! empty( $sub_value ) ) {
						$css_values[] = self::css_property_name( $sub_key ) . ':' . $sub_value;
					}
					break;
				default:
					break;
			}
		}

		return implode( ';', $css_values );
	}
}
