<?php
namespace Neurogenesis\Traits\Blocks;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

trait BorderStyles {
	public static $property = 'border';

	public static function border_style( $value ) {
		$css_values = array();

		if ( isset( $value['width'] ) ) {
			return self::css_property_name( self::$property ) . ':' . self::border_values( $value );
		}

		foreach ( $value as $sub_key => $sub_value ) {
			if ( $sub_key === 'all' ) {
				$css_values[] = self::$property . ':' . self::border_values( $sub_value );
			} else {
				$css_values[] = self::$property . '-' . self::css_property_name( $sub_key ) . ':' . self::border_values( $sub_value );
			}
		}

		return implode( ';', array_values( $css_values ) );
	}

	public static function border_values( $value ) {
		$style = isset( $value['style'] ) ? $value['style'] : 'solid';
		$width = isset( $value['width'] ) ? self::value_with_unit_var( $value['width'] ) : 0;
		$color = isset( $value['color'] ) ? $value['color'] : 'transparent';

		$border_values = $width . ' ' . $style . ' ' . $color;

		return $border_values;
	}

	public static function css_var_value( $value ) {
		if ( is_string( $value['value'] ) && ( strpos( $value['value'], 'var(' ) === 0 || strpos( $value['value'], '--' ) === 0 ) ) {
			if ( strpos( $value['value'], 'var(' ) > -1 ) {
				return $value['value'];
			}

			return 'var(' . $value['value'] . ')';
		}

		return $value['value'] . $value['unit'];
	}


	public static function value_with_unit_var( $value ) {
		if ( is_array( $value ) ) {
			return self::css_var_value( $value );
		}

		return $value;
	}

	public static function border_radius_style( $value ) {
		if ( is_array( $value ) ) {
			$values = array();

			foreach ( $value as $key => $value ) {
				if ( $key === 'all' ) {
					$values[] = self::$property . '-radius:' . self::value_with_unit_var( $value );
				} else {
					$values[] = self::$property . '-' . self::css_property_name( $key ) . '-radius:' . self::value_with_unit_var( $value );
				}
			}

			return implode( ';', $values );
		}

		return self::$property . '-radius:' . self::css_value( self::$property, $value );
	}
}
