<?php

namespace Neurogenesis\Traits\Blocks;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

trait BlockSizingStyles {

	public static function block_sizing_styles( $value ) {
		$css_values = array();

		foreach ( $value as $sub_key => $sub_value ) {
			if ( self::is_empty_value( $sub_value ) ) {
				continue;
			}
			$css_value = self::css_value_with_unit( $sub_value );

			if ( $css_value !== false && $css_value !== '' ) {
				$css_values[] = self::css_property_name( $sub_key ) . ':' . $css_value;
			}
		}

		return implode( ';', $css_values );
	}
}
