<?php

namespace Neurogenesis\Traits\Blocks;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

trait BlockDisplayStyles {

	public static function block_display_styles( $value ) {
		$css_values = array();
		$display    = $value['display'] ?? 'default';
		$position   = $value['position'] ?? 'default';

		foreach ( $value as $sub_key => $sub_value ) {
			if ( self::is_empty_value( $sub_value ) ) {
				continue;
			}

			switch ( $sub_key ) {
				case 'display':
				case 'position':
					if ( $sub_value !== 'default' ) {
						$css_values[] = self::css_property_name( $sub_key ) . ':' . $sub_value;
					}
					break;
				case 'opacity':
					if ( $sub_value !== '' ) {
						$css_values[] = self::css_property_name( $sub_key ) . ':' . $sub_value;
					}
					break;
				case 'zIndex':
					$css_value = self::css_value_with_unit( $sub_value, true );
					if ( $css_value !== false && $css_value !== '' ) {
						$css_values[] = self::css_property_name( $sub_key ) . ':' . $css_value;
					}
					break;
				case 'flexDirection':
				case 'flexWrap':
				case 'justifyContent':
				case 'alignItems':
					if ( $display === 'flex' ) {
						$css_values[] = self::css_property_name( $sub_key ) . ':' . $sub_value;
					}
					break;
				case 'gap':
					if ( $display === 'flex' ) {
						$css_value = self::css_value_with_unit( $sub_value );
						if ( $css_value !== false && $css_value !== '' ) {
							$css_values[] = self::css_property_name( $sub_key ) . ':' . $css_value;
						}
					}
					break;
				case 'top':
				case 'left':
				case 'right':
				case 'bottom':
					if ( $position === 'absolute' || $position === 'fixed' ) {
						$css_value = self::css_value_with_unit( $sub_value );
						if ( $css_value !== false && $css_value !== '' ) {
							$css_values[] = $sub_key . ':' . $css_value;
						}
					}
					break;
				default:
					break;
			}
		}

		return implode( ';', $css_values );
	}
}
