<?php

namespace Neurogenesis\Traits\Blocks;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

trait BackgroundStyles {

	public static function background_styles( $value ) {
		$css_values = array();

		foreach ( $value as $sub_key => $sub_value ) {
			switch ( $sub_key ) {
				case 'backgroundImage':
					if ( ! empty( $sub_value ) ) {
						$css_values[] = self::css_property_name( $sub_key ) . ':' . self::background_image( $sub_value );
					}
					break;

				case 'background':
				case 'backgroundColor':
				case 'backgroundSize':
				case 'backgroundPosition':
				case 'backgroundRepeat':
				case 'backgroundAttachment':
					if ( ! empty( $sub_value ) ) {
						$css_values[] = self::css_property_name( $sub_key ) . ':' . $sub_value;
					}
					break;
				default:
					break;
			}
		}

		return implode( ';', $css_values );
	}

	public static function background_image( $value ) {
		if ( ! empty( $value ) ) {
			return 'url(' . $value . ');';
		}

		return '';
	}
}
