<?php

namespace Neurogenesis\Structure;

class ThemeVariables {
	private $settings;

	public function __construct() {
		$this->settings = wp_get_global_settings();
	}

	public function get_all_fonts() {
		$fonts = array();

		// Theme.json declared fonts

		$theme_fonts = $this->settings['typography']['fontFamilies'] ?? array();
		if ( ! empty( $theme_fonts ) ) {
			if ( $theme_fonts['theme'] ) {
				foreach ( $theme_fonts['theme'] as $theme_font ) {
					$fonts[ $theme_font['slug'] ] = array(
						'name'       => $theme_font['name'],
						'fontFamily' => $theme_font['fontFamily'],
					);
				}
			}

			if ( array_key_exists( 'custom', $theme_fonts ) && ! empty( $theme_fonts['custom'] ) ) {
				foreach ( $theme_fonts['custom'] as $theme_font ) {
					$fonts[ $theme_font['slug'] ] = array(
						'name'       => $theme_font['name'],
						'fontFamily' => $theme_font['fontFamily'],
					);
				}
			}
		}

		return $fonts;
	}

	public function get_theme_color_var_name( $slug ) {
		return 'var(--wp--preset--color--' . $slug . ')';
	}

	public function get_theme_colors() {
		$colors = array();

		// Theme.json declared colors
		$theme_colors = $this->settings['color']['palette']['theme'] ?? array();
		if ( ! empty( $theme_colors ) ) {
			foreach ( $theme_colors as $theme_color ) {
				$colors[ $theme_color['slug'] ] = array(
					'name'     => $theme_color['name'],
					'color'    => $theme_color['color'],
					'var_name' => $this->get_theme_color_var_name( $theme_color['slug'] ),
				);
			}
		}

		return $colors;
	}

	public function get_theme_spacing() {
		$spacing = array();

		// Theme.json declared spacing
		$theme_spacing = $this->settings['spacing']['spacingSizes']['theme'] ?? array();

		if ( ! empty( $theme_spacing ) ) {
			foreach ( $theme_spacing as $theme_spacing ) {
				$spacing[ $theme_spacing['slug'] ] = array(
					'name'     => $theme_spacing['name'],
					'size'     => $theme_spacing['size'],
					'var_name' => $this->get_theme_spacing_var_name( $theme_spacing['slug'] ),
				);
			}
		}

		return $spacing;
	}

	public function get_theme_spacing_var_name( $slug ) {
		return 'var(--wp--preset--spacing--' . $slug . ')';
	}

	public function get_theme_font_sizes() {
		$font_sizes = array();

		// Theme.json declared font sizes
		$theme_font_sizes = $this->settings['typography']['fontSizes']['theme'] ?? array();

		if ( ! empty( $theme_font_sizes ) ) {
			foreach ( $theme_font_sizes as $theme_font_size ) {
				$font_sizes[ $theme_font_size['slug'] ] = array(
					'name'     => $theme_font_size['name'],
					'size'     => $theme_font_size['size'],
					'var_name' => $this->get_theme_font_size_var_name( $theme_font_size['slug'] ),
				);
			}
		}

		return $font_sizes;
	}

	public function get_theme_font_size_var_name( $slug ) {
		return 'var(--wp--preset--font-size--' . $slug . ')';
	}

}
