<?php
namespace Neurogenesis\Structure;

use Neurogenesis\Traits\HasTemplate;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Pagination {
	use HasTemplate;

	/**
	 * total
	 *
	 * @var int
	 */
	private $total = 0;

	/**
	 * totaPages
	 *
	 * @var int
	 */
	private $totalPages = 0;

	public function __construct( $total, $per_page = 10 ) {
		$this->total      = $total;
		$this->totalPages = ceil( $total / $per_page );
	}

	/**
	 * Render the pagination HTML
	 *
	 * @return void
	 */
	public function render( $route ) {
		$big = 999999999;

		$links = paginate_links(
			array(
				'base'         => str_replace( $big, '%#%', ( neuro_generate_page_url( $route, array( 'paged' => $big ) ) ) ),
				'total'        => $this->totalPages,
				'current'      => self::getPageNumber(),
				'format'       => '&paged=%#%',
				'show_all'     => false,
				'type'         => 'array',
				'end_size'     => 1,
				'mid_size'     => 2,
				'prev_next'    => true,
				'add_args'     => false,
				'add_fragment' => '',
				'prev_text'    => __( '« Prev', 'neurogenesis-styler' ),
				'next_text'    => __( 'Next »', 'neurogenesis-styler' ),
			)
		);

		$args = array(
			'total' => $this->total,
			'links' => $links,
		);

		return self::template( 'pagination', $args, false );
	}

	/**
	 * Get page number
	 *
	 * @return int
	 */
	public static function getPageNumber() {
		// Verify nonce for security
		if ( ! isset( $_GET['_wpnonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_GET['_wpnonce'] ) ), 'pagination_action' ) ) {
			return 1; // Return default page 1 if nonce verification fails
		}

		// Validate and sanitize input
		if ( ! isset( $_GET['paged'] ) || empty( $_GET['paged'] ) ) {
			return 1;
		}

		$paged = intval( $_GET['paged'] );
		if ( $paged <= 0 ) {
			return 1;
		}

		return $paged;
	}
}
