<?php

namespace Neurogenesis\Structure;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Assets {

	public function frontend() {}

	public function admin() {
		add_action( 'enqueue_block_assets', array( $this, 'enqueue_block_editor_assets' ), 9 );
	}

	public function enqueue_block_editor_assets() {
		$deps = array(
			'wp-components',
			'wp-element',
			'wp-i18n',
			'wp-blocks',
			'wp-editor',
			'wp-compose',
			'wp-hooks',
			'wp-edit-post',
		);

		$version         = time();
		$theme_variables = new ThemeVariables();

		// blocks
		wp_enqueue_script(
			'neuro-blocks',
			$this->assets_url( 'dist/js/neuro-blocks.js' ),
			$deps,
			$version,
			true
		);
		wp_enqueue_style( 'neuro-global-stylesheet', $this->assets_url( 'dist/neuro-blocks.css' ), array(), $version );

		// error_log( print_r( $theme_variables->get_theme_spacing(), true ) );

		wp_localize_script(
			'neuro-blocks',
			'neuro_blocks_data',
			array(
				'block_style_data' => NEUROGENESIS_BLOCK_SUPPORTS,
				'neuro_id'         => NEUROGENESIS_ID,
				'neuro_prefix'     => '.admin-color-' . NEUROGENESIS_ID,
				'disabled_blocks'  => NEUROGENESIS_DISABLED_BLOCKS,
				'fonts'            => $theme_variables->get_all_fonts(),
				'fontSizes'        => $theme_variables->get_theme_font_sizes(),
				'colors'           => $theme_variables->get_theme_colors(),
				'spacing'          => $theme_variables->get_theme_spacing(),
			)
		);

	}


	/**
	 * Load the scripts/styles
	 *
	 * @return void
	 */
	public function load() {
		$this->load_admin_assets();
	}

	/**
	 * Get the admin assets url
	 *
	 * @param  mixed $filename
	 * @return string
	 */
	public function assets_url( $filename ) {
		return neuro_url( 'assets/' . $filename );
	}

	/**
	 * Load the admin assets
	 *
	 * @return void
	 */
	public function load_admin_assets( $args = array() ) {

	}

	/**
	 * Loads an asset for specific routes.
	 *
	 * @param string $asset_url The URL of the asset to load.
	 * @param array $routes An array of routes for which the asset should be loaded.
	 * @param array $deps An array of dependencies for the asset.
	 * @param array $args Additional arguments for loading the asset.
	 * @return void
	 */
	public function load_asset_for_routes( $asset_url, $routes = array(), $deps = array(), $args = array() ) {
		if ( ! $this->is_neuro_route( $routes ) ) {
			return;
		}

		$version = time();
		$args    = wp_parse_args(
			$args,
			array(
				'in_footer' => true,
			)
		);

		if ( empty( $deps ) ) {
			// get filename without the extension from the path
			$filename = pathinfo( $asset_url, PATHINFO_FILENAME );
			// get the folder path from the $asset_path
			$asset_path      = pathinfo( $asset_url, PATHINFO_DIRNAME );
			$asset_file_deps = neuro_path( 'assets/' . $asset_path ) . '/' . $filename . '.asset.php';

			if ( file_exists( $asset_file_deps ) ) {
				$asset   = include $asset_file_deps;
				$deps    = $asset['dependencies'];
				$version = $asset['version'];
			}
		}

	}

	/**
	 * Checks if the current route is a Mango route.
	 *
	 * @param array $routes An array of routes to check against.
	 * @param int $page_id The ID of the Mango page.
	 * @return bool Returns true if the current route is a Mango route, false otherwise.
	 */
	public function is_neuro_route( $routes = array(), $page_id = NEUROGENESIS_PAGE_ID ) {
		// Verify nonce for security
		if ( ! isset( $_GET['_wpnonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_GET['_wpnonce'] ) ), 'assets_route_action' ) ) {
			return false;
		}

		if ( ! isset( $_GET['page'] ) || sanitize_text_field( wp_unslash( $_GET['page'] ) ) !== $page_id ) {
			return false;
		}

		if ( isset( $_GET['route'] ) && in_array( sanitize_text_field( wp_unslash( $_GET['route'] ) ), $routes ) ) {
			return true;
		}

		return false;
	}

}
