<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Helper functions for the Registry::class
 *
 */

if ( ! function_exists( 'neuro_registry_get' ) ) {
	/**
	 * neuro_registry_get Helper function to get a variable from the registry
	 *
	 * @param  string $name
	 * @param  mixed $default
	 * @return mixed value
	 */

	function neuro_registry_get( $name, $default = null ) {
		$registry = \Neurogenesis\Core\Registry::getInstance();
		return $registry->get( $name, $default );
	}
}

if ( ! function_exists( 'neuro_registry_set' ) ) {
	/**
	 * neuro_registry_set Helper function to set a variable into the registry
	 *
	 * @param  string $name
	 * @param  mixed $default
	 * @return void
	 */

	function neuro_registry_set( $name, $value ) {
		$registry = \Neurogenesis\Core\Registry::getInstance();
		$registry->set( $name, $value );
	}
}

if ( ! function_exists( 'neuro_registry_delete' ) ) {
	/**
	 * neuro_registry_delete Helper function to delete a variable fromt the registry
	 *
	 * @param  string $name
	 * @return void
	 */

	function neuro_registry_delete( $name ) {
		$registry = \Neurogenesis\Core\Registry::getInstance();
		$registry->delete( $name );
	}
}
