<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! function_exists( 'neuro_get_option' ) ) {
	function neuro_get_option( $option_name, $default = null ) {
		$option_path = neuro_option_path( $option_name );

		$option = get_option( $option_path[0], array() );
		return isset( $option[ $option_path[1] ] ) ? neuro_escape_value( $option[ $option_path[1] ] ) : $default;
	}
}

if ( ! function_exists( 'neuro_get_option_group' ) ) {
	function neuro_get_option_group( $group_name, $default = array() ) {
		$option = get_option( 'neuro_website_' . $group_name, array() );
		return isset( $option ) ? $option : $default;
	}
}

if ( ! function_exists( 'neuro_option_path' ) ) {
	// ai_options.open_ai_api_key should get the value of ['neuro_website_ai_options']['open_ai_api_key']
	function neuro_option_path( $option_path, $default = null ) {
		$option_path = explode( '.', $option_path );

		return array( 'neuro_website_' . $option_path[0], $option_path[1] );
	}
}

if ( ! function_exists( 'neuro_escape_value' ) ) {
	function neuro_escape_value( $value ) {
		if ( is_array( $value ) ) {
			return array_map( 'neuro_escape_value', $value );
		}
		return stripslashes( wp_unslash( $value ) );
	}
}
