<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Helper functions for the FlashMessages::class
 *
 */

if ( ! function_exists( 'neuro_flash_message_add' ) ) {
	/**
	 * neuro_flash_message_add Helper function to add a flash message
	 *
	 * @param  mixed $message
	 * @param  mixed $status
	 * @return void
	 */
	function neuro_flash_message_add( $message, $status = 'success' ) {
		$flash_messages = \Neurogenesis\Core\FlashMessages::getInstance();
		$flash_messages->addMessage( $message, $status );
	}
}

if ( ! function_exists( 'neuro_flash_messages_show' ) ) {
	/**
	 * neuro_flash_messages_show Helper function to display flash messages
	 *
	 * @param  mixed $echo
	 * @return void
	 */
	function neuro_flash_messages_show( $echo = true ) {
		$flash_messages = \Neurogenesis\Core\FlashMessages::getInstance();
		$flash_messages->displayMessages( $echo );
	}
}
