<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

// neuro_blocks_add
if ( ! function_exists( 'neuro_add_block' ) ) {
	/**
	 * Add blocks to the registry
	 *
	 * @param  array $blocks
	 * @return void
	 */
	function neuro_add_block( $block_type, $render_callback ) {
		$blocks                       = neuro_get_blocks();
		$blocks[ md5( $block_type ) ] = array(
			'json'            => $block_type,
			'render_callback' => $render_callback,
		);

		neuro_registry_set( 'gutenberg_blocks', $blocks );
	}
}

// neuro_blocks_get
if ( ! function_exists( 'neuro_get_blocks' ) ) {
	/**
	 * Get blocks from the registry
	 *
	 * @return array
	 */
	function neuro_get_blocks() {
		return neuro_registry_get( 'gutenberg_blocks', array() );
	}
}
