<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! function_exists( 'neuro_array_get' ) ) {
	/**
	 * Get an item from an array using "dot" notation.
	 *
	 * @param array $array The array to retrieve the value from.
	 * @param mixed $key The key to search for in the array.
	 * @param mixed $default The default value to return if the key is not found.
	 * @return mixed The value associated with the key, or the default value if the key is not found.
	 */
	function neuro_array_get( $array, $key, $default = null ) {
		if ( is_null( $key ) ) {
			return $array;
		}
		if ( isset( $array[ $key ] ) ) {
			return $array[ $key ];
		}
		foreach ( explode( '.', $key ) as $segment ) {
			if ( ! is_array( $array ) || ! array_key_exists( $segment, $array ) ) {
				return $default;
			}
			$array = $array[ $segment ];
		}
		return $array;
	}
}
