<?php
namespace Neurogenesis\Core;

use Neurogenesis\Traits\HasTemplate;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Router {
	use HasTemplate;
	/**
	 * namespace
	 *
	 * @var string
	 */
	private $namespace;

	/**
	 * route
	 *
	 * @var mixed
	 */
	private $route = false;

	public function __construct( $namespace ) {
		$this->namespace = $namespace;

		$this->resolveRoute();
	}

	/**
	 * Return the display callback
	 *
	 * @return array
	 */
	public function display() {
		return $this->route;
	}

	/**
	 * Try to get the corresponding route
	 *
	 * @return void
	 */
	public function resolveRoute() {
		// Verify nonce for security
		if ( ! isset( $_GET['_wpnonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_GET['_wpnonce'] ) ), 'router_action' ) ) {
			wp_die( esc_html__( 'Security check failed.', 'neurogenesis-styler' ) );
		}

		if ( isset( $_GET['page'] ) && sanitize_text_field( wp_unslash( $_GET['page'] ) ) == $this->namespace ) {
			if ( isset( $_GET['route'] ) ) {
				$route       = sanitize_text_field( wp_unslash( $_GET['route'] ) );
				$this->route = $this->loadRoute( $route );
			} else {
				$this->route = $this->loadRoute( false );
			}
		} else {
			$this->route = array( $this, 'empty' );
		}
	}

	/**
	 * Empty controller function
	 *
	 * @return void
	 */
	public function empty() {}

	/**
	 * No route was found
	 *
	 * @return void
	 */
	public function notFound() {
		$this->template( '_not_found', array() );
	}

	/**
	 * Load the corresponding route
	 *
	 * @param  mixed $route
	 * @return array
	 */
	public function loadRoute( $route = false ) {
		$routes = neuro_registry_get( 'admin.routes.web', array() );
		$found  = false;

		if ( array_key_exists( $this->namespace, $routes ) ) {
			if ( $route == false ) {
				// we show the first record from the routes array. this is the default route
				$default = array_key_first( $routes[ $this->namespace ] );
				neuro_registry_set( 'admin.routes.current', $default );

				$found = array( new $routes[ $this->namespace ][ $default ][0], $routes[ $this->namespace ][ $default ][1] );
			} elseif ( array_key_exists( $route, $routes[ $this->namespace ] ) ) {
				// we show the corresponding route
				$found = array( new $routes[ $this->namespace ][ $route ][0], $routes[ $this->namespace ][ $route ][1] );
				neuro_registry_set( 'admin.routes.current', $route );
			} else {
				// we found no corresponding route so we return a 404 template
				$found = array( $this, 'notFound' );
			}
		} else {
			// we found no corresponding route so we return a 404 template
			$found = array( $this, 'notFound' );
		}

		return $found;
	}
}
