<?php
namespace Neurogenesis\Core\Form;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class YesNoField {
	public static function generate( $name, $value = null, $placeholder = '', $required = false ) {
		$required   = $required ? 'required' : '';
		$uniq_id    = 'neuro-' . uniqid();
		$uniq_id_no = 'neuro-' . uniqid();

		ob_start();
		?>
		<div class="neuro-field">
			
				<span class=""><?php echo esc_html( $placeholder ); ?></span>

			<input type="radio" 
				required class="form-check-input" 
				name="<?php echo esc_attr( $name ); ?>" 
				value="1" 
				placeholder="<?php echo esc_attr( $placeholder ); ?>" 
				id="<?php echo esc_attr( $uniq_id ); ?>"
				<?php
				if ( intval( $value ) === 1 ) :
					?>
					checked<?php endif; ?>
				<?php echo esc_attr( $required ); ?>> 
				
				<label class="form-check-label" for="<?php echo esc_attr( $uniq_id ); ?>">
					<?php esc_html_e( 'Yes', 'neurogenesis-styler' ); ?>
				</label>

			<input type="radio"
				required class="form-check-input" 
				name="<?php echo esc_attr( $name ); ?>" 
				value="0" 
				id="<?php echo esc_attr( $uniq_id_no ); ?>"         
				<?php
				if ( intval( $value ) === 0 ) :
					?>
					checked<?php endif; ?>
				<?php echo esc_attr( $required ); ?>> 
				
				<label class="form-check-label" for="<?php echo esc_attr( $uniq_id_no ); ?>">
					<?php esc_html_e( 'No', 'neurogenesis-styler' ); ?>
				</label>
			
		</div>
		<?php
		// return the output
		return ob_get_clean();
	}
}
