<?php
namespace Neurogenesis\Core\Form;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class TextareaField {
	public static function generate( $name, $value = null, $placeholder = '', $required = false, $info = false ) {
		$required = $required ? 'required' : '';
		// use ob_start to buffer the output
		ob_start();
		?>
		<div class="neuro-field">
			<label class="input-group">
				<span class=""><?php echo esc_html( $placeholder ); ?></span>
				<textarea class="form-control" 
					name="<?php echo esc_attr( $name ); ?>" 
					spellcheck="false" 
					autocomplete="off" 
					placeholder="<?php echo esc_attr( $placeholder ); ?>" 
					<?php echo esc_attr( $required ); ?>><?php echo esc_textarea( $value ); ?></textarea>
			</label>
			<?php if ( $info !== false ) : ?>
				<div class="neuro-field-info"><?php echo wp_kses_post( $info ); ?></div>
			<?php endif; ?>
		</div>
		<?php
		// return the output
		return ob_get_clean();
	}
}
