<?php
namespace Neurogenesis\Core\Form;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class SelectField {
	public static function generate( $name, $value = null, $options = array(), $placeholder = '', $required = false ) {
		$required = $required ? 'required' : '';
		$uniq_id  = 'neuro-' . uniqid();

		ob_start();
		?>
		<div class="neuro-field">
			<label class="input-group">
				<span class=""><?php echo esc_html( $placeholder ); ?></span>
				<?php if ( empty( $options ) ) : ?>
					<p><?php esc_html_e( 'No options available', 'neurogenesis-styler' ); ?></p>
				<?php endif; ?>

				<select class="form-control" name="<?php echo esc_attr( $name ); ?>" id="<?php echo esc_attr( $uniq_id ); ?>" <?php echo esc_attr( $required ); ?>>                    
					<option value=""><?php esc_html_e( 'Choose', 'neurogenesis-styler' ); ?></option>
					
					<?php foreach ( $options as $key => $option ) : ?>
						<option value="<?php echo esc_attr( $option['value'] ); ?>" 
												  <?php
													if ( $option['value'] === $value ) :
														?>
							selected<?php endif; ?>><?php echo esc_html( $option['label'] ); ?></option>
					<?php endforeach; ?>
				</select>
			</label>
		</div>
		<?php
		// return the output
		return ob_get_clean();
	}
}
