<?php
namespace Neurogenesis\Core\Form;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class InputField {
	public static function generate( $name, $value = null, $input_type = 'text', $placeholder = '', $required = false, $readonly = false ) {
		$required = $required ? 'required' : '';
		$readonly = $readonly ? 'readonly' : '';
		// use ob_start to buffer the output
		ob_start();
		?>
		<div class="neuro-field">
			<label class="input-group">
				<span class=""><?php echo esc_html( $placeholder ); ?></span>
				<input type="<?php echo esc_attr( $input_type ); ?>" class="form-control" name="<?php echo esc_attr( $name ); ?>" value="<?php echo esc_attr( $value ); ?>" autocomplete="off" placeholder="<?php echo esc_attr( $placeholder ); ?>" <?php echo esc_attr( $required ); ?> <?php echo esc_attr( $readonly ); ?> >
			</label>
		</div>
		<?php
		// return the output
		return ob_get_clean();
	}
}
