<?php

namespace Neurogenesis\Core;

use Neurogenesis\Traits\IsSingleton;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class FlashMessages {

	use IsSingleton;

	/**
	 * optionName
	 *
	 * @var string
	 */
	private $optionName = 'sla_flash_messages';

	/**
	 * Adds a Flash Message
	 *
	 * @param  mixed $message
	 * @param  mixed $status
	 * @return array
	 */
	public function addMessage( $message, $status = 'success' ) {
		$messages   = $this->getMessages();
		$messages[] = array(
			'status'  => $status,
			'message' => $message,
		);
		$this->saveMessages( $messages );
	}

	/**
	 * Display all the Flash Messages
	 *
	 * @param  mixed $echo
	 * @return string
	 */
	public function displayMessages( $echo = true ) {
		$messages = $this->getMessages();
		$str      = '';

		if ( ! empty( $messages ) ) {
			ob_start();
			?>
			<div class="neuro-flash-messages">
				<?php foreach ( $messages as $key => $message ) : ?>
					<div class="neuro-flash-message neuro-flash-message-<?php echo esc_attr( $message['status'] ); ?>">
						<?php echo esc_html( $message['message'] ); ?>
					</div>
				<?php endforeach; ?>
			</div>
			<!-- /.cs-flash-messages -->
			<?php
			$str = ob_get_clean();
			$this->deleteMessages();
		}

		if ( ! $echo ) {
			return $str;
		}

		echo wp_kses_post( $str );
	}


	/**
	 * Get a list of Flash Messages
	 *
	 * @return array
	 */
	private function getMessages() {
		return get_transient( $this->optionName, array() );
	}

	/**
	 * Save a Flash Message
	 *
	 * @param  mixed $messages
	 * @return void
	 */
	private function saveMessages( $messages ) {
		set_transient( $this->optionName, $messages, 5 * MINUTE_IN_SECONDS ); //expires in 5 minutes
	}

	/**
	 * Deletes a Flash Message
	 *
	 * @return void
	 */
	private function deleteMessages() {
		delete_transient( $this->optionName );
	}
}
//Helper functions
//neuro_add_flash_message() - add a new Flash Message
//neuro_show_flash_messages() - display all the Flash Messages
