<?php

namespace Neurogenesis\Core\Blocks;
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class FrontendCSS {
	private static $template_cache_key = '_neuro_template_css_cache';
	private static $page_cache_key     = '_neuro_generated_css';

	public static function get_page_cache_key() {
		return self::$page_cache_key;
	}

	public static function get_template_cache_key() {
		return self::$template_cache_key;
	}

	public static function get_template_name( $post ) {
		if ( is_int( $post ) ) {
			$post = get_post( $post );
		}

		if ( ! $post ) {
			return '';
		}

		$template_name = get_post_meta( $post->ID, '_wp_page_template', true );
		if ( ! $template_name ) {
			$template_name = $post->post_name;
		}
		return $template_name;
	}

	public static function get_template_name_cache_key( $template_name ) {
		$theme = function_exists( 'get_stylesheet' ) ? get_stylesheet() : 'default';

		return $theme . '::template::' . $template_name;
	}


}
