<?php
namespace Neurogenesis\Core\Blocks;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class BlockStyles {
	public function generate( $post_id ) {
		$blocks = parse_blocks( get_post_field( 'post_content', $post_id ) );
		$css    = array();

		foreach ( $blocks as $block ) {
			$css = array_merge( $css, $this->process_block_recursively( $block ) );
		}

		return $this->generate_stylesheet( $css );
	}

	private function process_block_recursively( $block ) {
		$css = array();

		// Process current block if it has neuro styles
		if ( isset( $block['attrs']['neuro']['_styles'] ) ) {
			$block_styles = new BlockCSS( $block['attrs'], $block );
			$css[]        = $block_styles->generate_css();
		}

		// Process inner blocks recursively
		if ( isset( $block['innerBlocks'] ) && is_array( $block['innerBlocks'] ) ) {
			foreach ( $block['innerBlocks'] as $inner_block ) {
				$css = array_merge( $css, $this->process_block_recursively( $inner_block ) );
			}
		}

		// Also check for innerContent which might contain nested blocks
		if ( isset( $block['innerContent'] ) && is_array( $block['innerContent'] ) ) {
			foreach ( $block['innerContent'] as $inner_content ) {
				if ( is_array( $inner_content ) ) {
					$css = array_merge( $css, $this->process_block_recursively( $inner_content ) );
				}
			}
		}

		return $css;
	}

	private function generate_stylesheet( $css ) {
		$stylesheet     = '';
		$by_media_query = array();
		foreach ( $css as $block_css ) {
			foreach ( $block_css as $media_query => $styles ) {
				if ( ! isset( $by_media_query[ $media_query ] ) ) {
					$by_media_query[ $media_query ] = '';
				}
				$by_media_query[ $media_query ] .= $styles;
			}
		}

		foreach ( $by_media_query as $media_query => $styles ) {
			if ( $styles === '' ) {
				continue;
			}

			if ( $media_query === '' ) {
				$stylesheet .= '@media all {';
				$stylesheet .= $styles;
				$stylesheet .= '}';

			} else {
				$stylesheet .= '@media ' . $media_query . ' {';
				$stylesheet .= $styles;
				$stylesheet .= '}';
			}
		}
		return $stylesheet;
	}


}
