<?php
namespace Neurogenesis\Core\Blocks;

use Neurogenesis\Traits\IsBlock;
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
class BlockCSS {
	use IsBlock;

	public $mediaQueries = array(
		// 'desktop' => 'screen and (min-width: 783px)',
		'desktop' => '',
		'tablet'  => 'screen and (min-width: 601px) and (max-width: 782px)',
		'mobile'  => 'screen and (max-width: 600px)',

	);

	private $css = array();

	public function __construct( $attributes, $block ) {
		self::generate_for_css( $attributes, $block );

		$this->init_css();
	}

	private function init_css() {
		foreach ( $this->mediaQueries as $media => $query ) {
			$this->css[ $query ] = '';
		}
	}

	public function generate_css() {
		foreach ( $this->mediaQueries as $media => $query ) {
			$this->css[ $query ] .= $this->generate( $media );
		}

		return $this->css;
	}

	public function generate( $media ) {
		$block_styles = '';

		foreach ( self::$elements as $element => $options ) {
			$styles = self::get_element_styles( $element, $media );

			if ( ! empty( $styles ) ) {
				$path = isset( self::$elements[ $element ]['css_path'] ) ? self::$elements[ $element ]['css_path'] : self::generate_css_path( $element );

				$block_styles .= $this->generate_css_for_path( $path, $styles );
			}
		}

		return $block_styles;
	}



	public function generate_css_for_path( $path, $styles ) {
		$element_path = trim( $path );
		$css          = '';

		$states = isset( $styles['_states'] ) ? $styles['_states'] : array();

		if ( ! empty( $states ) ) {
			unset( $styles['_states'] );
			foreach ( $states as $state => $state_value ) {
				// Check if element_path contains pseudo-elements like :before, :after, etc.
				if ( preg_match( '/^(.+?)(:before|:after|:first-line|:first-letter|:selection|:placeholder|:backdrop|:marker|:spelling-error|:grammar-error|:target|:focus-within|:focus-visible|:is|:where|:not|:has|:dir|:lang|:any-link|:link|:visited|:active|:hover|:focus|:focus-visible|:target|:root|:empty|:enabled|:disabled|:checked|:indeterminate|:default|:valid|:invalid|:in-range|:out-of-range|:required|:optional|:read-only|:read-write|:placeholder-shown|:autofill|:user-invalid|:user-valid|:dir|:lang|:any-link|:link|:visited|:active|:hover|:focus|:focus-visible|:target|:root|:empty|:enabled|:disabled|:checked|:indeterminate|:default|:valid|:invalid|:in-range|:out-of-range|:required|:optional|:read-only|:read-write|:placeholder-shown|:autofill|:user-invalid|:user-valid)$/', $element_path, $matches ) ) {
					// Element path has pseudo-element, insert state before it
					$base_path          = $matches[1];
					$pseudo_element     = $matches[2];
					$state_element_path = $base_path . '.neuro--state-' . $state . $pseudo_element . ',' . $base_path . ':' . $state . $pseudo_element;
				} else {
					// No pseudo-element, use original logic
					$state_element_path = $element_path . '.neuro--state-' . $state . ',' . $element_path . ':' . $state;
				}

				$css .= $state_element_path . ' {' . $this->array_to_css( $state_value ) . '}';
			}
		}

		$css .= $element_path . ' {' . $this->array_to_css( $styles ) . '}';

		return $css;
	}

	public function array_to_css( $array ) {
		$css = array();
		foreach ( $array as $key => $value ) {
			if ( ! empty( $value ) ) {
				$css[] = $value;
			}
		}

		return implode( ';', $css );
	}
}
