<?php
namespace Neurogenesis\Core;
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
class Autoloader {
	private $fileExtension = '.php';
	private $namespace;
	private $include_path;
	private $namespace_separator = '\\';

	public function __construct( $namespace = null, $include_path = null ) {
		$this->namespace    = $namespace;
		$this->include_path = $include_path;
	}

	public function register() {
		spl_autoload_register( array( $this, 'loadClass' ) );
	}

	public function loadClass( $class_name ) {
		if ( $this->namespace . $this->namespace_separator === substr( $class_name, 0, strlen( $this->namespace . $this->namespace_separator ) ) ) {
			$parts     = explode( $this->namespace_separator, $class_name );
			$file_name = implode( DIRECTORY_SEPARATOR, array_slice( $parts, 1 ) ) . $this->fileExtension;

			require( $this->include_path !== null ? $this->include_path : '' ) . $file_name;
		}
	}
}

//Load the Neurogenesis namespace
$neuro_autoloader = new Autoloader( 'Neurogenesis', NEUROGENESIS_PATH . 'neuro/' );
$neuro_autoloader->register();
