<?php
namespace Neurogenesis\Core\Api;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class LoadApiRoutes {
	protected $apiNamespace    = 'neurogenesis-styler';
	protected $apiVersion      = 'v1';
	protected $apiRoutes       = array();
	const DELIMITER            = ':';
	const PERMISSION_DELIMITER = '@';

	public function __construct( $namespace, $version ) {
		$this->apiNamespace = $namespace;
		$this->apiVersion   = $version;
		$this->init();
	}

	public function init() {
		$routes = neuro_registry_get( 'admin.routes.api', array() );

		if ( isset( $routes[ $this->apiNamespace ][ $this->apiVersion ] ) ) {
			$this->apiRoutes = $routes[ $this->apiNamespace ][ $this->apiVersion ];
			$this->registerRoutes();
		}

	}

	public function registerRoutes() {
		if ( ! empty( $this->apiRoutes ) ) {
			add_action(
				'rest_api_init',
				function () {
					foreach ( $this->apiRoutes as $route_args => $callback ) {
						$route = $this->getRouteArgs( $route_args );
						// class methods for permission and api callback
						$callbacks = $this->buildCallback( $callback );

						register_rest_route(
							$this->apiNamespace . '/' . $this->apiVersion,
							'/' . $route['path'],
							array(
								'methods'             => $route['methods'],
								'callback'            => $this->apiMethod( $callbacks['class'], $callbacks['callback'] ),
								'permission_callback' => $this->permissionCallback( $callbacks['class'], $callbacks['permission'] ),
								'args'                => call_user_func( array( $callbacks['class'], $callbacks['data_arguments'] ), $callbacks['callback'] ),
							)
						);
					}
				}
			);
		}
	}

	public function apiMethod( $_class, $callback ) {
		return array( new $_class, $callback );
	}

	public function buildCallback( $callback ) {
		$permission = false;
		$_class     = $callback[0];

		if ( strpos( $callback[1], self::PERMISSION_DELIMITER ) !== false ) {
			$str        = explode( self::PERMISSION_DELIMITER, $callback[1] );
			$callback   = $str[0];
			$permission = $str[1];
		} else {
			$callback = $callback[1];
		}

		return array(
			'callback'       => $callback,
			'permission'     => $permission,
			'class'          => $_class,
			'data_arguments' => 'data_arguments',
		);
	}

	public function permissionCallback( $_class, $callback ) {
		if ( $callback === false ) {
			return array( new $_class, 'permission' );
		}

		return array( new $_class, $callback );

	}

	public function getRouteArgs( $route_args ) {
		$methods = 'GET';

		if ( strpos( $route_args, self::DELIMITER ) !== false ) {
			$str     = explode( self::DELIMITER, $route_args );
			$route   = $str[1];
			$methods = $str[0];
		} else {
			$route = $route_args;
		};

		return array(
			'methods' => $methods,
			'path'    => $route,
		);
	}
}
