<?php
namespace Neurogenesis\Core\Api;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class BasicApi {
	protected $apiNamespace = 'neurogenesis-styler';
	protected $apiVersion   = 'v1';
	protected $apiRoutes    = array();

	protected $body           = array();
	protected static $request = null;

	public function permission( \WP_REST_Request $request ) {
		return true;
	}

	public function response( $data, $status = 200 ) {
		return new \WP_REST_Response(
			array(
				'data' => $data,
				'code' => $status,
			)
		);
	}

	public function error( $message, $status = 400 ) {
		return new \WP_REST_Response(
			array(
				'code'    => 'error',
				'message' => $message,
				'status'  => $status,
			)
		);
	}

	public function success( $message, $status = 200 ) {
		return new \WP_REST_Response(
			array(
				'code'    => 'success',
				'message' => $message,
				'status'  => $status,
			)
		);
	}

	public function response_resource_created( $data, $success_message = null, $error_message = null ) {
		if ( $data ) {
			return $this->success( $success_message === null ? __( 'Resource created', 'neurogenesis-styler' ) : $success_message );
		}

		return $this->error( $error_message === null ? __( 'Resource not created', 'neurogenesis-styler' ) : $error_message );
	}

	/**
	 * parse_param
	 *
	 * @param  mixed $param
	 * @param  mixed $default
	 * @return mixed
	 */
	public function get_param( $param, $default = null ) {
		if ( isset( self::$request[ $param ] ) ) {
			return self::$request[ $param ];
		}

		return $default;
	}

	public function get_params() {
		return self::$request->get_params();
	}

	public function data_validate( $value, $request, $param ) {
		return array();
	}

	public function data_sanitize( $value, $request, $param ) {
		return array();
	}

	public static function data_arguments( $route ) {
		return array();
	}

	public function random_lorem_string( $max = 10 ) {
		$words = array( 'lorem', 'ipsum', 'dolor', 'sit', 'amet', 'consectetur', 'adipiscing', 'elit', 'praesent', 'interdum', 'dictum', 'mi', 'non', 'egestas', 'nulla', 'in', 'lacus', 'sed', 'sapien', 'placerat', 'malesuada', 'at', 'erat', 'etiam', 'id', 'velit', 'finibus', 'viverra', 'maecenas', 'mattis', 'volutpat', 'justo', 'vitae', 'vestibulum', 'metus', 'lobortis', 'mauris', 'luctus', 'leo', 'feugiat', 'nibh', 'tincidunt', 'a', 'integer', 'facilisis', 'lacinia', 'ligula', 'ac', 'suspendisse', 'eleifend', 'nunc', 'nec', 'pulvinar', 'quisque', 'ut', 'semper', 'auctor', 'tortor', 'mollis', 'est', 'tempor', 'scelerisque', 'venenatis', 'quis', 'ultrices', 'tellus', 'nisi', 'phasellus', 'aliquam', 'molestie', 'purus', 'convallis', 'cursus', 'ex', 'massa', 'fusce', 'felis', 'fringilla', 'faucibus', 'varius', 'ante', 'primis', 'orci', 'et', 'posuere', 'cubilia', 'curae', 'proin', 'ultricies', 'hendrerit', 'ornare', 'augue', 'pharetra', 'dapibus', 'nullam', 'sollicitudin', 'euismod', 'eget', 'pretium', 'vulputate', 'urna', 'arcu', 'porttitor', 'quam', 'condimentum', 'consequat', 'tempus', 'hac', 'habitasse', 'platea', 'dictumst', 'sagittis', 'gravida', 'eu', 'commodo', 'dui', 'lectus', 'vivamus', 'libero', 'vel', 'maximus', 'pellentesque', 'efficitur', 'class', 'aptent', 'taciti', 'sociosqu', 'ad', 'litora', 'torquent', 'per', 'conubia', 'nostra', 'inceptos', 'himenaeos', 'fermentum', 'turpis', 'donec', 'magna', 'porta', 'enim', 'curabitur', 'odio', 'rhoncus', 'blandit', 'potenti', 'sodales', 'accumsan', 'congue', 'neque', 'duis', 'bibendum', 'laoreet', 'elementum', 'suscipit', 'diam', 'vehicula', 'eros', 'nam', 'imperdiet', 'sem', 'ullamcorper', 'dignissim', 'risus', 'aliquet', 'habitant', 'morbi', 'tristique', 'senectus', 'netus', 'fames', 'nisl', 'iaculis', 'cras', 'aenean' );
		$lorem = '';
		$size  = wp_rand( 3, $max );
		while ( $size > 0 ) {
			$random_word = array_rand( $words );
			$lorem      .= $words[ $random_word ] . ' ';
			$size --;
		}
		return ucfirst( $lorem );

	}

	public function random_lorem_ipsum( $sentences = 5 ) {
		$lorem = '';
		while ( $sentences > 0 ) {
			$lorem .= $this->random_lorem_string( \wp_rand( 5, 15 ) ) . '. ';
			$sentences--;
		}
		return $lorem;
	}
}
