<?php
namespace Neurogenesis\Controllers\Blocks;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class BlockRegistry {
	private $blocks = array();

	public function __construct( $blocks ) {
		$this->blocks = $blocks;
		$this->include_blocks();

		add_action( 'init', array( $this, 'register_blocks' ) );
	}

	public function register_blocks() {
		$registered_blocks = neuro_get_blocks();

		foreach ( $registered_blocks as $id => $options ) {
			register_block_type(
				$options['json'],
				array(
					'render_callback' => array( $options['render_callback'], 'init' ),
				)
			);
		}
	}

	private function include_blocks() {
		foreach ( $this->blocks as $block ) {
			require_once NEUROGENESIS_PATH . 'assets/js/gutenberg/src/blocks/library/' . $block . '/index.php';
		}
	}
}
