<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$neuro_presets = apply_filters( 'neuro_element_presets', neuro_element_presets() );

$neuro_block_supports = array(
	// gutenberg widgets blocks
		'core/archives'    => array(
			'elements' => array(
				'WRAPPER'          => neuro_block_add_to_preset(
					$neuro_presets['WRAPPER_EMPTY'],
					array(
						'label'      => 'Archives Wrapper',
						'is_wrapper' => false,
					)
				),
				'LIST'             => neuro_block_add_to_preset(
					$neuro_presets['LIST_WRAPPER'],
					array(
						'label'      => 'Archives List',
						'selector'   => 'ul',
						'is_wrapper' => true,
					)
				),

				'LIST_ITEM'        => neuro_block_add_to_preset(
					$neuro_presets['LIST_ITEM'],
					array(
						'label'    => 'Archive Item',
						'selector' => 'li',
					)
				),
				'DROPDOWN_WRAPPER' => neuro_block_add_to_preset(
					$neuro_presets['WRAPPER'],
					array(
						'label'      => 'Dropdown Wrapper',
						'selector'   => '.wp-block-archives-dropdown',
						'is_wrapper' => array( 'displayAsDropdown', true ),
					)
				),
				'DROPDOWN'         => neuro_block_add_to_preset(
					$neuro_presets['LIST_ITEM'],
					array(
						'label'    => 'Dropdown',
						'selector' => 'select',
					)
				),
				'DROPDOWN_LABEL'   => neuro_block_add_to_preset(
					$neuro_presets['WRAPPER'],
					array(
						'label'    => 'Dropdown Label',
						'selector' => 'label',
					)
				),
				'LINKS'            => $neuro_presets['LINKS'],
			),
		),

	'core/calendar'        => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Calendar Wrapper',
					'selector' => '.wp-block-calendar',
				)
			),
			'TABLE'   => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Calendar Table',
					'selector' => 'table',
				)
			),
			'CAPTION' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Calendar Caption',
					'selector' => 'caption',
				)
			),
			'THEAD'   => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Calendar Header',
					'selector' => 'thead',
				)
			),
			'TBODY'   => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Calendar Body',
					'selector' => 'tbody',
				)
			),
			'TR'      => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Calendar Row',
					'selector' => 'tr',
				)
			),
			'TH'      => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Calendar Header Cell',
					'selector' => 'th',
				)
			),
			'TD'      => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Calendar Cell',
					'selector' => 'td',
				)
			),
			'NAV'     => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Calendar Nav',
					'selector' => 'nav',
				)
			),
			'LINKS'   => $neuro_presets['LINKS'],
		),
	),

	'core/categories'      => array(
		'elements' => array(
			'WRAPPER'        => neuro_block_add_to_preset(
				$neuro_presets['LIST_WRAPPER'],
				array(
					'label'     => 'Categories List',
					'className' => '.wp-block-categories',
				)
			),

			'LIST_ITEM'      => neuro_block_add_to_preset(
				$neuro_presets['LIST_ITEM'],
				array(
					'label'    => 'Category Item',
					'selector' => 'li',
				)
			),
			'DROPDOWN'       => neuro_block_add_to_preset(
				$neuro_presets['LIST_ITEM'],
				array(
					'label'    => 'Dropdown',
					'selector' => 'select',
				)
			),
			'DROPDOWN_LABEL' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Dropdown Label',
					'selector' => '.wp-block-categories__label',
				)
			),
			'LINKS'          => $neuro_presets['LINKS'],
		),
	),

	'core/latest-comments' => array(
		'elements' => array(
			'WRAPPER'         => neuro_block_add_to_preset(
				$neuro_presets['LIST_WRAPPER'],
				array(
					'label'    => 'Latest Comments Wrapper',
					'selector' => 'ol.wp-block-latest-comments',
				)
			),
			'COMMENT_ITEM'    => neuro_block_add_to_preset(
				$neuro_presets['LIST_WRAPPER'],
				array(
					'label'    => 'Comment Item',
					'selector' => 'li.wp-block-latest-comments__comment',
				)
			),
			'COMMENT_IMAGE'   => neuro_block_add_to_preset(
				$neuro_presets['IMAGE'],
				array(
					'label'    => 'Comment Image',
					'selector' => 'img.wp-block-latest-comments__comment-avatar',
				)
			),
			'ARTICLE'         => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Comment Article',
					'selector' => 'article',
				)
			),
			'FOOTER'          => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Comment Meta Wrapper',
					'selector' => 'footer.wp-block-latest-comments__comment-meta',
				)
			),
			'COMMENT_AUTHOR'  => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Comment Author',
					'selector' => 'a.wp-block-latest-comments__comment-author',
				)
			),
			'COMMENT_TITLE'   => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Comment Title',
					'selector' => 'a.wp-block-latest-comments__comment-link',
				)
			),
			'COMMENT_DATE'    => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Comment Date',
					'selector' => 'time.wp-block-latest-comments__comment-date',
				)
			),
			'COMMENT_EXCERPT' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Comment wrapper',
					'selector' => '.wp-block-latest-comments__comment-excerpt',
				)
			),
			'COMMENT_CONTENT' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Comment text',
					'selector' => 'p',
				)
			),
			'LINKS'           => $neuro_presets['LINKS'],
		),
	),

	'core/rss'             => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['LIST_WRAPPER'],
				array(
					'label'    => 'RSS Wrapper',
					'selector' => 'ul.wp-block-rss',
				)
			),
			'ITEM'    => neuro_block_add_to_preset(
				$neuro_presets['LIST_ITEM'],
				array(
					'label'    => 'RSS Item',
					'selector' => 'li',
				)
			),
			'TITLE'   => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'RSS Title',
					'selector' => '.wp-block-rss__item-title',
				)
			),
			'DATE'    => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'RSS Date',
					'selector' => '.wp-block-rss__item-publish-date',
				)
			),
			'AUTHOR'  => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'RSS Author',
					'selector' => '.wp-block-rss__item-author',
				)
			),
			'EXCERPT' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'RSS Excerpt',
					'selector' => '.wp-block-rss__item-excerpt',
				)
			),
			'LINKS'   => $neuro_presets['LINKS'],
		),
	),

	'core/latest-posts'    => array(
		'elements' => array(
			'WRAPPER'            => neuro_block_add_to_preset(
				$neuro_presets['LIST_WRAPPER'],
				array(
					'label'    => 'Latest Posts Wrapper',
					'selector' => '.wp-block-latest-posts__list',
				)
			),
			'POST_ITEM'          => neuro_block_add_to_preset(
				$neuro_presets['LIST_ITEM'],
				array(
					'label'    => 'Post Item',
					'selector' => 'li',
				)
			),
			'POST_IMAGE_WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Post Image Wrapper',
					'selector' => '.wp-block-latest-posts__featured-image',
				)
			),
			'POST_IMAGE'         => neuro_block_add_to_preset(
				$neuro_presets['IMAGE'],
				array(
					'label'    => 'Post Image',
					'selector' => 'img',
				)
			),
			'POST_TITLE'         => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Post Title',
					'selector' => 'li a.wp-block-latest-posts__post-title',
				)
			),
			'POST_AUTHOR'        => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Post Author',
					'selector' => '.wp-block-latest-posts__post-author',
				)
			),
			'POST_DATE'          => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Post Date',
					'selector' => 'time',
				)
			),
			'POST_EXCERPT'       => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Post Excerpt',
					'selector' => '.wp-block-latest-posts__post-full-content',
				)
			),
			'LINKS'              => $neuro_presets['LINKS'],
		),
	),

	'core/page-list'       => array(
		'elements' => array(
			'WRAPPER'        => neuro_block_add_to_preset(
				$neuro_presets['LIST_WRAPPER'],
				array(
					'label'    => 'Page List Wrapper',
					'selector' => '.wp-block-page-list',
				)
			),
			'PAGE_ITEM'      => neuro_block_add_to_preset(
				$neuro_presets['LIST_ITEM'],
				array(
					'label'    => 'Page Item',
					'selector' => '.wp-block-pages-list__item',
				)
			),
			'PAGE_TITLE'     => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Page Title',
					'selector' => '.wp-block-pages-list__item a',
				)
			),
			'SUB_LIST'       => neuro_block_add_to_preset(
				$neuro_presets['LIST_WRAPPER'],
				array(
					'label'    => 'Sub List',
					'selector' => '.wp-block-pages-list__item ul.wp-block-navigation__submenu-container',
				)
			),
			'SUB_LIST_ITEM'  => neuro_block_add_to_preset(
				$neuro_presets['LIST_ITEM'],
				array(
					'label'    => 'Sub List Item',
					'selector' => '.wp-block-pages-list__item ul.wp-block-navigation__submenu-container li.wp-block-pages-list__item ',
				)
			),
			'SUB_LIST_TITLE' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Sub List Title',
					'selector' => '.wp-block-pages-list__item ul.wp-block-navigation__submenu-container li.wp-block-pages-list__item a',
				)
			),
			'LINKS'          => $neuro_presets['LINKS'],
		),
	),

	'core/search'          => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Search Wrapper',
					'selector' => 'form.wp-block-search',
				)
			),
			'LABEL'   => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Search Label',
					'selector' => '.wp-block-search__label',
				)
			),
			'INPUT'   => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Search Input',
					'selector' => 'input.wp-block-search__input',
				)
			),
			'BUTTON'  => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Search Button',
					'selector' => 'button.wp-block-search__button',
				)
			),
		),
	),

	'core/social-links'    => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Social Links Wrapper',
					'selector' => '.wp-block-social-links',
				)
			),
			'ITEM'    => neuro_block_add_to_preset(
				$neuro_presets['LIST_ITEM'],
				array(
					'label'    => 'Social Link Item',
					'selector' => 'li',
				)
			),
			'LABEL'   => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Social Link Label',
					'selector' => '.wp-block-social-link-label',
				)
			),
		),
	),
	'core/social-link'     => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'     => 'Social Link Icon',
					'className' => '.wp-block-social-link',
					'tag'       => 'li',
				)
			),
		),
	),

);

add_filter(
	'neuro_block_supports_schema',
	function( $schema ) use ( $neuro_block_supports ) {
		return array_merge( $schema, $neuro_block_supports );
	},
	10,
	2
);
